% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpArea.R
\name{kpArea}
\alias{kpArea}
\title{kpArea}
\usage{
kpArea(karyoplot, data=NULL, chr=NULL, x=NULL, y=NULL, base.y=0, ymin=NULL, ymax=NULL, data.panel=1, r0=NULL, r1=NULL, col=NULL, border=NULL, clipping=TRUE, ...)
}
\arguments{
\item{karyoplot}{(a \code{KaryoPlot} object) This is the first argument to all data plotting functions of \code{karyoploteR}. A KaryoPlot object referring to the currently active plot.}

\item{data}{(a \code{GRanges}) A GRanges object with the data. If \code{data} is present, \code{chr} will be set to \code{seqnames(data)} and \code{x} to the midpoints of the rages in data. If no parameter \code{y} is specified and \code{data} has a column named \code{y} or \code{value} this column will be used to define the \code{y} value of each data point. (defaults to NULL)}

\item{chr}{(a charecter vector) A vector of chromosome names specifying the chromosomes of the data points. If \code{data} is not NULL, \code{chr} is ignored. (defaults to NULL)}

\item{x}{(a numeric vector) A numeric vector with the positions (in base pairs) of the data points in the chromosomes. If \code{data} is not NULL, \code{x} is ignored. (defaults to NULL)}

\item{y}{(a numeric vector) A numeric vector with the values of the data points. If \code{y} is not NULL, it is used instead of any data column in \code{data}. (defaults to NULL)}

\item{base.y}{(numeric) The y value at which the polygon will be closed. (defaults to 0)}

\item{ymin}{(numeric) The minimum value of \code{y} to be plotted. If NULL, it is set to the min value of the selected data panel. (defaults to NULL)}

\item{ymax}{(numeric) The maximum value of \code{y} to be plotted. If NULL, it is set to the max value of the selected data panel. (defaults to NULL)}

\item{data.panel}{(numeric) The identifier of the data panel where the data is to be plotted. The available data panels depend on the plot type selected in the call to \code{\link{plotKaryotype}}. (defaults to 1)}

\item{r0}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{r1}{(numeric) r0 and r1 define the vertical range of the data panel to be used to draw this plot. They can be used to split the data panel in different vertical ranges (similar to tracks in a genome browser) to plot differents data. If NULL, they are set to the min and max of the data panel, it is, to use all the available space. (defaults to NULL)}

\item{col}{(color) The fill color of the area. A single color. If NULL the color will be assigned automatically, either a lighter version of the color used for the outer line or gray if the line color is not defined. If NA no area will be drawn. (defaults to NULL)}

\item{border}{(color) The color of the line enclosing the area. A single color. If NULL the color will be assigned automatically, either a darker version of the color used for the area or black if col=NA. If NA no border will be drawn. (Defaults to NULL)}

\item{clipping}{(boolean) Only used if zooming is active. If TRUE, the data representation will be not drawn out of the drawing area (i.e. in margins, etc) even if the data overflows the drawing area. If FALSE, the data representation may overflow into the margins of the plot. (defaults to TRUE)}

\item{...}{The ellipsis operator can be used to specify any additional graphical parameters. Any additional parameter will be passed to the internal calls to the R base plotting functions.}
}
\value{
Returns the original karyoplot object, unchanged.
}
\description{
Plots a line joining the data points along the genome and fills the area below the line.
}
\details{
This is a karyoploteR low-level plotting functions. Given a set of positions 
on the genome (chromosome and base) and a value (y) for each of them, it 
plots a line joining them and shades the area below them. Data can be 
provided via a \code{GRanges} object (\code{data}), independent parameters 
for chr, x and y or a combination of both. A number of parameters can be used
to define exactly where and how the line and area are drawn. In addition, 
via the ellipsis operator (\code{...}), \code{kpArea} accepts any parameter 
valid for \code{\link[graphics]{lines}} and \code{\link[graphics]{polygon}}
(e.g. \code{lwd}, \code{lty}, \code{col}, \code{density}...) The lines are drawn in a per 
chromosome basis, so it is not possible to draw lines encompassing more than 
one chromosome.
}
\examples{
 
set.seed(1000)
data.points <- sort(createRandomRegions(nregions=500, mask=NA))
mcols(data.points) <- data.frame(y=runif(500, min=0, max=1))

kp <- plotKaryotype("hg19", plot.type=2, chromosomes=c("chr1", "chr2"))
  kpDataBackground(kp, data.panel=1)
  kpDataBackground(kp, data.panel=2)

  kpArea(kp, data=data.points)
  kpArea(kp, data=data.points, col="lightgray", border="red", lty=2, r0=0, r1=0.5)
  kpArea(kp, data=data.points, border="red", data.panel=2, r0=0, r1=0.5)
  kpArea(kp, data=data.points, border="blue", data.panel=2, r0=0, r1=0.5, base.y=1)

  kpArea(kp, data=data.points, border="gold", data.panel=2, r0=0.5, r1=1, base.y=0.5)


 
}
\seealso{
\code{\link{plotKaryotype}}, \code{\link{kpLines}}, \code{\link{kpText}}, \code{\link{kpPlotRibbon}}
}
