% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosLollipop}
\alias{CircosLollipop}
\title{LOLLIPOP module}
\usage{
CircosLollipop(
  modulename,
  compareGroup = 1,
  fillColor = "#9400D3",
  secondColor = "#FFFFFF",
  pointType = "circle",
  circleSize = 2,
  diamondWidth = 10,
  diamondHeight = 5,
  rectWidth = 2,
  rectHeight = 2,
  stroke = TRUE,
  strokeColor = "#000000",
  strokeWidth = 0.5,
  lineAutoHeight = TRUE,
  lineAutoMaximumHeightZoomRate = 1,
  lineHeightRate = 0.75,
  lineWidth = 2,
  lineColor = "#000000",
  realStart = 0,
  ValueAxisManualScale = FALSE,
  ValueAxisMaxScale = 10,
  ValueAxisMinScale = 0,
  animationDisplay = FALSE,
  animationTime = 2000,
  animationDelay = 20,
  animationType = "bounce",
  data,
  ...
)
}
\arguments{
\item{modulename}{The name of the new module}

\item{compareGroup}{The group number of this module in compare module}

\item{fillColor}{Filling color for lollipop}

\item{secondColor}{Second filling color for heterogeneous lollipop}

\item{pointType}{The type for lollipop, could be circle, rect and diamond}

\item{circleSize}{If circle, the size for lollipop}

\item{diamondWidth, diamondHeight}{If diamond, the width and height for lollipop}

\item{rectWidth, rectHeight}{If rect, the width and height for lollipop}

\item{stroke}{Whether display the stroke for lollipop}

\item{strokeColor, strokeWidth}{The color and width for stroke}

\item{lineAutoHeight}{Whether auto assign the height for each lollipop}

\item{lineAutoMaximumHeightZoomRate}{If auto assign, the zoom rate for each lollipop}

\item{lineHeightRate}{If manually assign, the rate of lollipop compared to real value}

\item{lineWidth, lineColor}{The width and color for the line of lollipop}

\item{realStart}{The real start position for data in genome}

\item{ValueAxisManualScale}{Whether manually control the scale of value}

\item{ValueAxisMaxScale, ValueAxisMinScale}{The max and min scale value for manually control}

\item{animationDisplay}{Whether display animation}

\item{animationTime, animationDelay, animationType}{The time, delay and display type for animation}

\item{data}{A list of lollipop value with details including protein, chr, pos, strand, CancerTypeNumber, color, link,
Consequence, AA_pos, AA_change, type, link and html.
Details can be found on document}

\item{...}{Ignored}
}
\value{
The module tracks for lollipop modules.
}
\description{
Create a lollipop plot
}
\examples{
lollipopData<-lollipopExample
arcData<-arcExample
Circos(CircosLollipop('Lollipop01', data=lollipopData, fillColor="#9400D3",
circleSize= 6, strokeColor= "#999999", strokeWidth= "1px", animationDisplay=TRUE, lineWidth= 2,
realStart= 101219350)+CircosArc('Arc01', outerRadius = 212, innerRadius = 224, data=arcData),
 genome=list("EGFR"=1211),outerRadius = 220,genomeFillColor = c("grey"))

}
