% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosHistogram}
\alias{CircosHistogram}
\title{HISTOGRAM module}
\usage{
CircosHistogram(
  modulename,
  compareGroup = 1,
  maxRadius = 108,
  minRadius = 95,
  ValueAxisManualScale = FALSE,
  ValueAxisMaxScale = 10,
  ValueAxisMinScale = 0,
  fillColor = "red",
  animationDisplay = FALSE,
  animationTime = 2000,
  animationDelay = 20,
  data,
  ...
)
}
\arguments{
\item{modulename}{The name of the new module}

\item{compareGroup}{The group number of this module in compare module}

\item{maxRadius, minRadius}{Where the module should begin and end}

\item{ValueAxisManualScale}{Whether manually control the scale of value}

\item{ValueAxisMaxScale, ValueAxisMinScale}{The max and min scale value for manually control}

\item{fillColor}{The color for histgram}

\item{animationDisplay}{Whether display animation}

\item{animationTime, animationDelay}{The time and delay for animation}

\item{data}{A list of value with details including chr, start, end, name, link, value and html. Details can be found on document}

\item{...}{Ignored}
}
\value{
The module tracks for histogram modules
}
\description{
Create a multi-layer histogram plot
}
\examples{

histogramData<-histogramExample
Circos(CircosHistogram('HISTOGRAM01', data = histogramData,fillColor= "#ff7f0e",maxRadius = 210,
minRadius = 175),genome=list("2L"=23011544,"2R"=21146708,"3L"=24543557,"3R"= 27905053,
"X"=22422827,"4"=1351857),
outerRadius = 220)

}
