% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infercnv_sampling.R
\name{plot_per_group}
\alias{plot_per_group}
\title{plot_per_group}
\usage{
plot_per_group(
  infercnv_obj,
  on_references = TRUE,
  on_observations = TRUE,
  sample = FALSE,
  n_cells = 1000,
  every_n = NULL,
  above_m = 1000,
  k_obs_groups = 1,
  base_filename = "infercnv_per_group",
  output_format = "png",
  write_expr_matrix = TRUE,
  save_objects = FALSE,
  png_res = 300,
  dynamic_resize = 0,
  useRaster = TRUE,
  out_dir
)
}
\arguments{
\item{infercnv_obj}{infercnv_object}

\item{on_references}{boolean (default=TRUE), plot references (normal cells).}

\item{on_observations}{boolean (default=TRUE), plot observations data (tumor cells).}

\item{sample}{Whether unique groups of cells should be sampled from or not. (see other parameters for how sampling is done) (Default: FALSE)}

\item{n_cells}{Number of cells that should be sampled per group if sampling is enabled (default = 1000) .}

\item{every_n}{Sample 1 cell every_n cells for each group that has above_m cells, if sampling is enabled. 
If subclusters are defined, this will make sure that at least one cell per subcluster is sampled. 
Requires above_m to be set to work, overriding n_cells parameter. (Default: NULL)}

\item{above_m}{Sample only groups that have at least above_m cells if sampling is enabled. (default: 1000)
Does not require every_n to be set.}

\item{k_obs_groups}{Number of groups to break each group in with cutree (in the color bars on the left side of the plot only). (Default: 1)}

\item{base_filename}{Base prefix for the output files names. 
Will be followed by OBS/REF to indidate the type of the group, and the group name. (Default: "infercnv_per_group")}

\item{output_format}{Output format for the figure. Choose between "png", "pdf" and NA. NA means to only write the text outputs without generating the figure itself. (default: "png")}

\item{write_expr_matrix}{Includes writing a matrix file containing the expression data that is plotted in the heatmap. (default: FALSE)}

\item{save_objects}{Whether to save the infercnv objects generated for each group as RDS. (default: FALSE)}

\item{png_res}{Resolution for png output. (Default: 300)}

\item{dynamic_resize}{Factor (>= 0) by which to scale the dynamic resize of the observation 
heatmap and the overall plot based on how many cells there are.
Default is 0, which disables the scaling. Try 1 first if you want to enable. (Default: 0)}

\item{useRaster}{Whether to use rasterization for drawing heatmap. Only disable if it produces an error as it is much faster than not using it.}

\item{out_dir}{Directory in which to save plots and other outputs.}
}
\value{
void
}
\description{
Takes an infercnv object and subdivides it into one object per group of cells 
to allow plotting of each group on a seperate plot. If references are selected, they will appear
on the observation heatmap area as it is larger.
}
\examples{
# data(infercnv_data_example)
# data(infercnv_annots_example)
# data(infercnv_genes_example)

# infercnv_object_example <- infercnv::CreateInfercnvObject(raw_counts_matrix=infercnv_data_example, 
#                                                           gene_order_file=infercnv_genes_example,
#                                                           annotations_file=infercnv_annots_example,
#                                                           ref_group_names=c("normal"))

# infercnv_object_example <- infercnv::run(infercnv_object_example,
#                                          cutoff=1,
#                                          out_dir=tempfile(), 
#                                          cluster_by_groups=TRUE, 
#                                          denoise=TRUE,
#                                          HMM=FALSE,
#                                          num_threads=2,
#                                          no_plot=TRUE)

data(infercnv_object_example)

infercnv::plot_per_group(infercnv_object_example, out_dir=tempfile())

}
