% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainOGRDB.R
\name{loadOGRDB}
\alias{loadOGRDB}
\title{Load Cached OGRDB Sequences}
\usage{
loadOGRDB(
  species = "human",
  locus = c("IGH", "IGK", "IGL"),
  set_name = NULL,
  type = c("NUC", "PROT"),
  format = c("FASTA_GAPPED", "FASTA_UNGAPPED", "AIRR"),
  version = c("published", "latest"),
  species_subgroup = NULL,
  suppressMessages = FALSE
)
}
\arguments{
\item{species}{Character string specifying the species. Accepts
\code{"human"}, \code{"Homo sapiens"}, \code{"mouse"}, or
\code{"Mus musculus"}. Default is \code{"human"}.}

\item{locus}{Character string specifying the locus short code. One of
\code{"IGH"}, \code{"IGK"}, or \code{"IGL"}. Can be \code{NULL} if you pass
a \code{set_name} explicitly.}

\item{set_name}{Optional character string specifying an explicit OGRDB set
name (e.g., \code{"IGH_VDJ"}). If provided, overrides \code{locus}.}

\item{type}{Character string specifying the sequence type. Either
\code{"NUC"} (default) for nucleotide or \code{"PROT"} for protein.
\code{"PROT"} will translate V-gene CDS; only supported for FASTA or AIRR
records that include a valid CDS.}

\item{format}{Character string specifying the download format. One of
\code{"FASTA_GAPPED"} (default), \code{"FASTA_UNGAPPED"}, or \code{"AIRR"}.}

\item{version}{Character string specifying the version. Either
\code{"published"} (default) or \code{"latest"}.}

\item{species_subgroup}{Optional character string specifying a subgroup
(e.g., a mouse strain like \code{"C57BL/6"}). If it contains \code{/},
OGRDB requires it encoded as \code{\%252f}.}

\item{suppressMessages}{Logical. If \code{TRUE}, suppresses informational
messages. Default is \code{FALSE}.}
}
\value{
A \code{\link[Biostrings]{DNAStringSet}} object (when
  \code{type = "NUC"}) or \code{\link[Biostrings]{AAStringSet}} object (when
  \code{type = "PROT"}) containing the requested sequences.
}
\description{
Loads sequences from the local cache without attempting to
download. This function is a convenience wrapper for
\code{getOGRDB(refresh = FALSE)}. If the data is not found in the cache, it
will be downloaded unless an internet connection is unavailable.
}
\examples{
if (is_ogrdb_available()) {
  # First, ensure the file is cached
  getOGRDB(species = "human", locus = "IGH",
           type = "NUC", format = "FASTA_GAPPED",
           suppressMessages = TRUE)

  # Now load from cache only
  igh_cached <- loadOGRDB(species = "human",
                          locus   = "IGH",
                          type    = "NUC",
                          format  = "FASTA_GAPPED")
}
}
\seealso{
\code{\link{getOGRDB}} for the main download function

\code{\link{refreshOGRDB}} to force re-download
}
