% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{exportTRUST4}
\alias{exportTRUST4}
\title{Export Reference Sequences to TRUST4 Format}
\usage{
exportTRUST4(sequences, output_file, include_constant = TRUE)
}
\arguments{
\item{sequences}{A \code{\link[Biostrings]{DNAStringSet}} object containing
immune receptor sequences. Sequence names must follow standard IG/TR gene
nomenclature (e.g., \code{"IGHV1-2*01"}). Can be obtained from
\code{\link{getIMGT}} or \code{\link{getOGRDB}}.}

\item{output_file}{Character string specifying the path to the output FASTA
file. The parent directory will be created if it does not exist.}

\item{include_constant}{Logical. If \code{TRUE} (default), include constant
region sequences. TRUST4's \code{IMGT+C.fa} file includes constant regions.}
}
\value{
Character string with the path to the created file, returned
  invisibly.
}
\description{
Exports a \code{\link[Biostrings]{DNAStringSet}} to a FASTA file
formatted for use with TRUST4. The output follows the format produced by
TRUST4's \code{BuildImgtAnnot.pl} script.
}
\details{
TRUST4 expects FASTA files with headers containing only the allele name
(e.g., \code{>IGHV1-2*01}). The function reformats sequence headers to match
the output of TRUST4's \code{BuildImgtAnnot.pl} script.

TRUST4 uses this reference for the \code{--ref} parameter in its analysis
pipeline.

This function works with sequences from both \strong{IMGT} (via
\code{\link{getIMGT}}) and \strong{OGRDB} (via \code{\link{getOGRDB}}).
}
\examples{
# Create a small example DNAStringSet
seqs <- Biostrings::DNAStringSet(c(
  "ATGCGATCGATCGATCG",
  "ATGCGATCGATCG",
  "ATGCGATC"
))
names(seqs) <- c("IGHV1-2*01", "IGHJ1*01", "IGHC*01")

# Export to temporary file
output_file <- tempfile(fileext = ".fa")
exportTRUST4(seqs, output_file)

# View the result
cat(readLines(output_file), sep = "\n")

# Clean up
unlink(output_file)
}
\seealso{
\code{\link{getIMGT}}, \code{\link{getOGRDB}} for obtaining sequences

\code{\link{exportMiXCR}}, \code{\link{exportCellRanger}},
\code{\link{exportIgBLAST}} for other export formats

\url{https://github.com/liulab-dfci/TRUST4} for TRUST4 documentation
}
