% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleMatrix.R
\name{scaleMatrix}
\alias{scaleMatrix}
\title{Fast Matrix Scaling or Transformation}
\usage{
scaleMatrix(
  x,
  method = c("minmax", "z", "robust_z", "unit_var", "l2", "l1", "sqrt", "log1p", "log2",
    "log10", "arcsinh", "none"),
  margin = 2,
  range = c(0, 1),
  offset = 1e-08,
  cofactor = 5,
  na.rm = TRUE
)
}
\arguments{
\item{x}{Numeric matrix (coerced with \code{as.matrix()}).}

\item{method}{Character scalar. One of:
\itemize{
  \item \code{"minmax"}   – rescale linearly to [\code{range}].
  \item \code{"z"}        – mean 0 / sd 1 (per margin).
  \item \code{"robust_z"} – median 0 / MAD 1 (outlier-resistant).
  \item \code{"unit_var"} – divide by sd (keep mean shifts).
  \item \code{"l2"}, \code{"l1"} – divide by Euclidean / L1 norm.
  \item \code{"sqrt"}     – element-wise square-root.
  \item \code{"log1p"}    – element-wise \code{log1p(x + offset)}.
  \item \code{"log2"}, \code{"log10"} – logs with small offset.
  \item \code{"arcsinh"}  – \code{asinh(x / cofactor)} (Flow/CyTOF).
  \item \code{"none"}     – return unchanged.
}}

\item{margin}{1 = operate row-wise, 2 = column-wise (default 2).}

\item{range}{Numeric length-2 vector for \code{method = "minmax"}.}

\item{offset}{Non-negative scalar added before logs / sqrt
(\emph{ignored} otherwise). Default \code{1e-8}.}

\item{cofactor}{Numeric > 0 for \code{method = "arcsinh"} (default 5).}

\item{na.rm}{Logical; drop NAs when computing summaries.}
}
\value{
Matrix of identical dimension (dimnames preserved).
}
\description{
Applies a chosen transformation to every row *or* column of a numeric
matrix without altering its dimensions.  Designed for lightweight
pre-processing pipelines ahead of machine-learning models.
}
\examples{
m <- matrix(rnorm(20), 4, 5,
            dimnames = list(paste0("g", 1:4), paste0("s", 1:5)))
scaleMatrix(m, "minmax")
scaleMatrix(m, "robust_z", margin = 1)
scaleMatrix(m, "l2")                          
scaleMatrix(abs(m), "arcsinh", cofactor = 150)
}
