% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequenceDecoder.R
\name{sequenceDecoder}
\alias{sequenceDecoder}
\title{Decode Amino Acid or Nucleotide Sequences}
\usage{
sequenceDecoder(
  encoded.object,
  mode = c("onehot", "property"),
  property.set = NULL,
  property.matrix = NULL,
  call.threshold = 0.5,
  sequence.dictionary = amino.acids,
  padding.symbol = ".",
  remove.padding = TRUE
)
}
\arguments{
\item{encoded.object}{A `list` object produced by `sequenceEncoder`, or a
numeric `matrix` (flattened 2D) or `array` (3D cube) from it.}

\item{mode}{The encoding mode used for decoding: `"onehot"` or `"property"`.
This is typically inferred if `encoded.object` is a list from `sequenceEncoder`.}

\item{property.set}{For `mode = "property"`, a character vector of property
names (e.g., `"atchleyFactors"`) that were used for the original encoding.
See `?sequenceEncoder`. This is ignored if `property.matrix` is supplied.}

\item{property.matrix}{For `mode = "property"`, the exact numeric matrix
(with dimensions `20 x P`) that was used for encoding. This overrides
`property.set`.}

\item{call.threshold}{A numeric confidence threshold for making a call.
- In `"onehot"` mode, this is the minimum required value in the vector (e.g., `0.9`).
- In `"property"` mode, this is the maximum allowable Euclidean distance.
Positions with scores not meeting the threshold are assigned the `padding.symbol`.}

\item{sequence.dictionary}{A character vector of the alphabet (e.g., amino acids).
Must match the one used during encoding.}

\item{padding.symbol}{The single character used to represent padding or
low-confidence positions.}

\item{remove.padding}{Logical. If `TRUE`, trailing padding symbols are
removed from the end of the decoded sequences.}
}
\value{
A character vector of the decoded sequences.
}
\description{
Transforms one-hot or property-encoded sequences back into their original
character representation. This function serves as the inverse to
`sequenceEncoder`.
}
\examples{
# Example sequences
aa.sequences <- c("CAR", "YMD", "ACAC")

# Encode the sequences
encoded.onehot <- sequenceEncoder(aa.sequences, 
                                  mode = "onehot")
encoded.prop <- sequenceEncoder(aa.sequences, 
                                mode = "property", 
                                property.set = "atchleyFactors")

# Decode the sequences
# 1. Decode from the full list object
decoded.1 <- sequenceDecoder(encoded.onehot, 
                             mode = "onehot")

# 2. Decode from just the 3D cube array
decoded.2 <- sequenceDecoder(encoded.prop$cube,
                             mode = "property",
                             property.set = "atchleyFactors")


}
