% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWASTrack.R
\docType{class}
\name{GWASTrack-class}
\alias{GWASTrack-class}
\alias{.GWASTrack}
\alias{GWASTrack}
\title{Constructor for GWASTrack}
\usage{
GWASTrack(
  trackName,
  data,
  chrom.col,
  pos.col,
  pval.col,
  trackHeight = 50,
  autoscale = TRUE,
  minY = 0,
  maxY = 30
)
}
\arguments{
\item{trackName}{A character string, used as track label by igv, 
we recommend unique names per track.}

\item{data}{a data.frame or a url pointing to one, 
whose structure is described by chrom.col, pos.col, pval.col}

\item{chrom.col}{numeric, the column number of the chromosome column}

\item{pos.col}{numeric, the column number of the position column}

\item{pval.col}{numeric, the column number of the GWAS pvalue column}

\item{trackHeight}{numeric in pixels}

\item{autoscale}{logical}

\item{minY}{numeric for explicit (non-auto) scaling}

\item{maxY}{numeric for explicit (non-auto) scaling}
}
\value{
A GWASTrack object
}
\description{
\code{GWASTrack} creates an \code{IGV} manhattan track from GWAS data
}
\examples{
file <-
  # a local gwas file
  system.file(package = "igvShiny", "extdata", "gwas-5k.tsv.gz")
tbl.gwas <- read.table(file,
                       sep = "\t",
                       header = TRUE,
                       quote = "")
dim(tbl.gwas)
track <-
  GWASTrack(
    "gwas 5k",
    tbl.gwas,
    chrom.col = 12,
    pos.col = 13,
    pval.col = 28
  )
getUrl(track)

url <- "https://gladki.pl/igvShiny/gwas_sample.tsv.gz"
track <- GWASTrack(
  "remote url gwas",
  url,
  chrom.col = 3,
  pos.col = 4,
  pval.col = 10,
  autoscale = FALSE,
  minY = 0,
  maxY = 300,
  trackHeight = 100
)
getUrl(track)


}
\keyword{GWASTrack_class}
