% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantitativeTrack.R
\docType{class}
\name{QuantitativeTrack-class}
\alias{QuantitativeTrack-class}
\alias{.QuantitativeTrack}
\alias{QuantitativeTrack}
\title{Constructor for QuantitativeTrack}
\usage{
QuantitativeTrack(
  trackName,
  quantitativeData,
  fileFormat = c("wig", "bigWig", "bedGraph", "gwas"),
  color = "gray",
  sourceType = c("file", "url"),
  trackHeight = 50,
  autoscale = TRUE,
  min = NA_real_,
  max = NA_real_,
  visibilityWindow = 1e+05
)
}
\arguments{
\item{trackName}{A character string, used as track label by igv, we recommend unique names per track.}

\item{quantitativeData}{A polyvalent object, either a data.frame, GRanges, or UCSCBedGraphQuantitative object}

\item{fileFormat}{only "bedGraph" supported at present; wig and bigWig support soon.}

\item{color}{A CSS color name (e.g., "red" or "#FF0000")}

\item{sourceType}{only "file" supported at present ("gcs" for Google Cloud Storage, and "ga4gh" for the Global Alliance API may come)}

\item{trackHeight}{track height, typically in range 20 (for annotations) and up to 1000 (for large sample vcf files)}

\item{autoscale}{Autoscale track to maximum value in view}

\item{min}{Sets the minimum value for the data (y-axis) scale. Usually zero.}

\item{max}{Sets the maximum value for the data (y-axis) scale. This value is ignored if autoscale is TRUE}

\item{visibilityWindow}{Maximum window size in base pairs for which indexed annotations or variants are displayed. Defaults: 1 MB for variants, whole chromosome for other track types.}
}
\value{
A QuantitativeTrack object
}
\description{
\code{QuantitativeTrack} creates an \code{IGV} track for genomic tracks in which a numerical value is
associated with each reported location.
}
\details{
Detailed description will go here
}
