% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWASTrack.R, R/GWASUrlTrack.R
\docType{class}
\name{GWASTrack-class}
\alias{GWASTrack-class}
\alias{.GWASTrack}
\alias{GWASTrack}
\alias{.GWASUrlTrack}
\title{Constructor for GWASTrack}
\usage{
GWASTrack(
  trackName,
  table,
  chrom.col,
  pos.col,
  pval.col,
  colorTable = list(),
  autoscale = TRUE,
  min = 0,
  max = 10,
  trackHeight = 50,
  visibilityWindow = 1e+05
)
}
\arguments{
\item{trackName}{A character string, used as track label by igv, we recommend unique names per track.}

\item{table}{data.frame of 6 or more columns}

\item{chrom.col}{numeric, the column number of the chromosome column}

\item{pos.col}{numeric, the column number of the position column}

\item{pval.col}{numeric, the column number of the GWAS pvalue colum}

\item{colorTable}{a named list of CSS colors, by chromosome name - exact matches to
the names in the GWAS table.}

\item{autoscale}{logical, controls how min and max of the y-axis are determined}

\item{min}{numeric when autoscale is FALSE, use this minimum y}

\item{max}{numeric when autoscale is FALSE, use this maximum y}

\item{trackHeight}{track height, typically in range 20 (for annotations) and up to 1000 (for large sample vcf files)}

\item{visibilityWindow}{Maximum window size in base pairs for which indexed annotations or variants are displayed. Defaults: 1 MB for variants, whole chromosome for other track types.}
}
\value{
A GWASTrack object
}
\description{
\code{GWASTrack} creates an \code{IGV} manhattan track GWAS data
}
\examples{

  file <- system.file(package="igvR", "extdata", "gwas-5k.tsv")
  tbl.gwas <- read.table(file, sep="\t", header=TRUE, quote="")
  dim(tbl.gwas)
  track <- GWASTrack("gwas 5k", tbl.gwas, chrom.col=12, pos.col=13, pval.col=28)

  if(interactive()){
    igv <- igvR()
    setGenome(igv, "hg38")
    setBrowserWindowTitle(igv, "GWAS demo")
    displayTrack(igv, track)
    Sys.sleep(1)  # pause before zooming in
    showGenomicRegion(igv, "chr6:32,240,829-32,929,353")
    }

}
