% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{draw_idr_distribution_histogram}
\alias{draw_idr_distribution_histogram}
\title{Create histogram of IDR values}
\usage{
draw_idr_distribution_histogram(
  df,
  remove_na = TRUE,
  xlab = "IDR",
  ylab = "density",
  title = "IDR value distribution"
)
}
\arguments{
\item{df}{part of output of \code{\link{estimate_idr}}, a data frame with at
least the following named columns:
\tabular{rl}{
  \code{idr} \tab IDR of the peak and the
  corresponding peak in the other replicate.
}}

\item{remove_na}{logical; should NA values be removed?}

\item{xlab}{character; x axis label}

\item{ylab}{character; y axis label}

\item{title}{character; plot title}
}
\value{
ggplot2 object; IDR distribution histogram
}
\description{
Creates diagnostic plots to visualize the results of
\code{\link{estimate_idr}}.
}
\examples{
idr_results <- estimate_idr1d(idr2d:::chipseq$rep1_df,
                              idr2d:::chipseq$rep2_df,
                              value_transformation = "log")
draw_idr_distribution_histogram(idr_results$rep1_df)

}
