% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEEedgeR-class.R
\docType{methods}
\name{iSEEedgeRResults-class}
\alias{iSEEedgeRResults-class}
\alias{iSEEedgeRResults}
\alias{showAsCell,iSEEedgeRResults-method}
\alias{pValue,iSEEedgeRResults-method}
\alias{log2FoldChange,iSEEedgeRResults-method}
\alias{averageLog2,iSEEedgeRResults-method}
\alias{embedContrastResults,TopTags-method}
\alias{embedContrastResults,iSEEedgeRResults-method}
\title{The iSEEedgeRResults class}
\description{
The \code{iSEEedgeRResults} class is used to provide a common interface to differential expression results produced by the \pkg{edgeR} package.
It provides methods to access common differential expression statistics (e.g., log fold-change, p-value, log2 average abundance).
}
\details{
This class inherits all its slots directly from its parent class \linkS4class{DataFrame}.
}
\section{Constructor}{

\code{iSEEedgeRResults(data, row.names = rownames(data))} creates an instance of a \code{iSEEedgeRResults} class, with:

\describe{
\item{\code{data}}{A \code{data.frame} produced by \code{edgeR::topTags()}.}
\item{\code{row.names}}{The character vector of rownames for the \linkS4class{SummarizedExperiment} object in which the object is to be embedded. Must be a superset of \code{rownames(data)}.}
}
}

\section{Supported methods}{

\itemize{
\item \code{embedContrastResults(x, se, name, ...)} embeds \code{x} in \code{se} under the identifier \code{name}. See \code{\link[=embedContrastResults]{embedContrastResults()}} for more details.
\item \code{pValue(x)} returns the vector of raw p-values.
\item \code{log2FoldChange(x)} returns the vector of log2-fold-change values.
\item \code{averageLog2(x)} returns the vector of average log2-expression values.
}
}

\examples{
library(edgeR)
library(SummarizedExperiment)

##
# From edgeR::glmLRT() ----
##

nlibs <- 3
ngenes <- 100
dispersion.true <- 0.1

# Make first gene respond to covariate x
x <- 0:2
design <- model.matrix(~x)
beta.true <- cbind(Beta1=2,Beta2=c(2,rep(0,ngenes-1)))
mu.true <- 2^(beta.true \%*\% t(design))

# Generate count data
y <- rnbinom(ngenes*nlibs,mu=mu.true,size=1/dispersion.true)
y <- matrix(y,ngenes,nlibs)
colnames(y) <- c("x0","x1","x2")
rownames(y) <- paste("gene",1:ngenes,sep=".")
d <- DGEList(y)

# Normalize
d <- calcNormFactors(d)

# Fit the NB GLMs
fit <- glmFit(d, design, dispersion=dispersion.true)

# Likelihood ratio tests for trend
results <- glmLRT(fit, coef=2)
tt <- topTags(results)

##
# iSEEedgeRResults ----
##

# Simulate the original SummarizedExperiment object
se <- SummarizedExperiment(assays = list(counts = d$counts))

# Embed the edgeR results in the SummarizedExperiment object
se <- embedContrastResults(tt, se, name = "edgeR")

##
# Access ----
##

contrastResultsNames(se)
contrastResults(se)
contrastResults(se, "edgeR")

head(pValue(contrastResults(se, "edgeR")))
head(log2FoldChange(contrastResults(se, "edgeR")))
head(averageLog2(contrastResults(se, "edgeR")))
}
\author{
Kevin Rue-Albrecht
}
