% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface_hidden.R
\name{.conditionalOnRadio}
\alias{.conditionalOnRadio}
\alias{.conditionalOnCheckSolo}
\alias{.conditionalOnCheckGroup}
\title{Conditional elements on radio or checkbox selection}
\usage{
.conditionalOnRadio(id, choice, ...)

.conditionalOnCheckSolo(id, on_select = TRUE, ...)

.conditionalOnCheckGroup(id, choice, ...)
}
\arguments{
\item{id}{String containing the ID of the UI element controlling the relevant choice.}

\item{choice}{String containing the choice for the radio button or checkbox group on which to show the conditional element(s).}

\item{...}{UI elements to show conditionally.}

\item{on_select}{Logical scalar specifying whether the conditional element should be shown upon selection in a check box, or upon de-selection (if \code{FALSE}).}
}
\value{
A HTML object containing interface elements in \code{...} that only appear when the relevant condition is satisfied.
}
\description{
Creates a conditional UI element that appears when the user picks a certain choice in a radio button, single checkbox or checkbox group interface element.
}
\details{
These functions are just wrappers around \code{\link{conditionalPanel}},
with the added value coming from the pre-written conditional expressions in Javascript.
They are useful for hiding elements that are only relevant when the right radio button or checkbox is selected.
This means that we avoid cluttering the UI with options that are not immediately useful to the user.
}
\seealso{
\code{\link{conditionalPanel}}, which is used under the hood.
}
\author{
Aaron Lun
}
