% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctClusterAssignments.R
\name{fctClusterAssignments}
\alias{fctClusterAssignments}
\title{fctClusterAssignments}
\usage{
fctClusterAssignments(cluster, phenoData = NULL, selectedColumns = NULL)
}
\arguments{
\item{cluster}{A data frame containing cluster assignments.}

\item{phenoData}{A data frame with the annotation names of the Dataset. Should have a column called Feature_ID.}

\item{selectedColumns}{Columns selected for the user to merge in the cluster assignments table}
}
\value{
A data frame containing cluster assignments and selected columns by user.
}
\description{
Cluster assignments with annotation.
}
\examples{
# Simulated cluster assignment data
cluster_df <- data.frame(
  feature = paste0("F", 1:5),
  cluster = paste0("cluster_", 1:5),
  col = RColorBrewer::brewer.pal(5, "Set1"),
  stringsAsFactors = FALSE
)

# Simulated annotation data
pheno_df <- data.frame(
  Feature_ID = paste0("F", 1:5),
  Symbol = c("GeneA", "GeneB", "GeneC", "GeneD", "GeneE"),
  Description = paste("Description", 1:5),
  stringsAsFactors = FALSE
)

# Run without selected columns
fctClusterAssignments(cluster_df, phenoData = pheno_df)

# Run with selected columns
fctClusterAssignments(cluster_df, phenoData = pheno_df, selectedColumns = "Description")

}
