% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_generator.R
\name{bed_generator}
\alias{bed_generator}
\title{Generate BED file for WGS dataset.}
\usage{
bed_generator(chr = numeric(), hg = numeric(), start = NULL, end = NULL,
  by = 1000)
}
\arguments{
\item{chr}{Specify the chromosome you want to generate. Must be of int from 1-22. Type integer.}

\item{hg}{Specify the coordinate you want to generate from. Start and end position of hg19 and hg38 have been pre-implemented. Type integer.}

\item{start}{The start position of your BED file. Default NULL}

\item{end}{The end position of your BED file. Default NULL}

\item{by}{The chunk of your DNA for each bin. Type integer. Default 1000.}
}
\value{
void
}
\description{
Default position generated from USCS genome browser
}
\examples{
bed_generator(chr=22,hg=38)
bed_generator(22,38,5001,10000,by=500)
}
