\name{calculateThreshold}
\alias{calculateThreshold}

\title{
Calculate PPA significance threshold leading to a desired false discovery rate
}
\description{
In the context of multiple testing and discoveries, a popular 
approach is to use a common threshold leading to a desired false 
discovery rate (FDR). In the Bayesian paradigm, derivation of the 
PPA threshold is trivial and can be calculated using a direct posterior
probability calculation as described in Newton et al. (2004).
}
\usage{
calculateThreshold(prob, threshold)
}

\arguments{
  \item{prob}{matrix or data frame that contains Posterior 
  Probability of Association  (output of eqtlMcmc function).}
  \item{threshold}{ The desired false discovery rate.}
}
\value{
\item{cutoff}{The significance threshold value}
}
\references{
Newton, MA., Noueiry, A., Sarkar, D. and Ahlquist, P. (2004): "Detecting differential gene expression with a semiparametric hierarchical mixture method."Biometrics, 5(2), 155-176}

\examples{
data(PPA.liver)
cutoff.liver <- calculateThreshold(PPA.liver, 0.2)
}
