% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyp_to_rmd.R
\name{hyp_to_rmd}
\alias{hyp_to_rmd}
\title{Export hyp object to rmarkdown}
\usage{
hyp_to_rmd(
  hyp_obj,
  file_path,
  title = "Workflow Report",
  subtitle = "",
  author = "",
  header = "Results",
  versioning = TRUE,
  show_dots = TRUE,
  show_emaps = TRUE,
  show_hmaps = FALSE,
  show_tables = TRUE,
  hyp_dots_args = list(top = 15, val = "fdr"),
  hyp_emap_args = list(top = 25, val = "fdr", similarity_metric = "jaccard_similarity",
    similarity_cutoff = 0.2),
  hyp_hmap_args = list(top = 25, val = "fdr"),
  custom_rmd_config = NULL,
  custom_pre_content = NULL,
  custom_post_content = NULL,
  session_info = FALSE
)
}
\arguments{
\item{hyp_obj}{A hyp object, multihyp object, or list of multihyp objects}

\item{file_path}{A file path}

\item{title}{Title of markdown report}

\item{subtitle}{Subtitle of markdown report}

\item{author}{Authors of markdown report}

\item{header}{Header name of tabset section}

\item{versioning}{Add versioning information}

\item{show_dots}{Option to show dots plots in tabs}

\item{show_emaps}{Option to show enrichment maps in tabs}

\item{show_hmaps}{Option to show hiearchy maps in tabs}

\item{show_tables}{Option to show table in tabs}

\item{hyp_dots_args}{A list of keyword arguments passed to hyp_dots}

\item{hyp_emap_args}{A list of keyword arguments passed to hyp_emap}

\item{hyp_hmap_args}{A list of keyword arguments passed to hyp_hmap}

\item{custom_rmd_config}{Replace configuration section of markdown report}

\item{custom_pre_content}{Insert custom content before tabset section}

\item{custom_post_content}{Insert custom content after tabset section}

\item{session_info}{Use true to include session info}
}
\description{
Export hyp object to rmarkdown
}
