% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_near_cells.R
\name{findNearCells}
\alias{findNearCells}
\title{Find the k-th nearest cells for each cell}
\usage{
findNearCells(
  dat,
  k = 100,
  targetCell = FALSE,
  reportCellID = FALSE,
  reportDist = TRUE,
  anno_col = 0
)
}
\arguments{
\item{dat}{A SpatialExperiment object, can be generated using function \code{readHoodData}.}

\item{k}{The maximum number of nearest cells to compute.}

\item{targetCell}{Specify the cells to be the target cell for finding nearest cells.}

\item{reportCellID}{Logical. Set to TRUE to report cell id instead of cell types.}

\item{reportDist}{Logical. Set to TRUE to report the distance matrix.}

\item{anno_col}{Character vector. The name of annotation column to use.}
}
\value{
A list includes a data.frame and a matrix, describing the cell types
and distances of the k-th nearest cells of each cell.
}
\description{
Find the k-th nearest cells for each cell
}
\details{
The \code{findNearCells} function uses the \code{nn2} function from the \code{RANN} package,
which uses the Approximate Near Neighbor (ANN) C++ library. For more infromation on the
ANN library please see http://www.cs.umd.edu/~mount/ANN/.
}
\examples{

data("spe_test")

spe <- readHoodData(spe, anno_col = "celltypes")

fnc <- findNearCells(spe, k = 100)

}
