% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternHeatmap.R
\docType{methods}
\name{PatternHeatmap}
\alias{PatternHeatmap}
\alias{PatternHeatmap,DNAStringSet,character-method}
\alias{PatternHeatmap,DNAStringSet,matrix-method}
\title{Generate a Heatmap of patterns in DNA sequence}
\usage{
PatternHeatmap(seq, pattern, ...)

\S4method{PatternHeatmap}{DNAStringSet,character}(seq, pattern, coords = NULL,
  min.score = NULL, label = NULL)

\S4method{PatternHeatmap}{DNAStringSet,matrix}(seq, pattern, coords = NULL,
  min.score = "80\%", label = NULL)
}
\arguments{
\item{seq}{A DNAString of equal length}

\item{pattern}{A nucleotide pattern or PWM}

\item{...}{additional arguments used by methods

This function creates a Heatmap from a set of DNA sequences. The resulting
heatmap will be binary, with 1 representing a match and 0 otherwise. Patterns
can be specified as a character vectore, eg. "CTCCC", or as a PWM. These
arguments are passed to Biostrings functions, `vmatchPattern` and `matchPWM`.
Character arguments can contain standard ambiguity codes. PWMs must be 4 by n
matricies with columns names ACGT. "min.score" is specified either as an absolute
value, or more commonly as a percentage e.g. "80%". Refer to Biostrings documentation
for details.

PatternHeatmaps often look much better after smoothing.}

\item{coords}{Co-ordinates for the heatmap, defaults to c(0, width(windows))}

\item{min.score}{Minimum score for PWM match}

\item{label}{Label for the heatmap}
}
\value{
A heatmap
}
\description{
Generate a Heatmap of patterns in DNA sequence
}
\section{Methods (by class)}{
\itemize{
\item \code{seq = DNAStringSet,pattern = character}: Heatmap of sequence patterns from sequence and character

\item \code{seq = DNAStringSet,pattern = matrix}: Heatmap of sequence patterns from sequence and matrix
}}

\examples{
data(HeatmapExamples)
PatternHeatmap(string_set, "TA", coords=c(-100, 100), label="TA")
PatternHeatmap(string_set, tata_pwm, coords=c(-100, 100), min.score="80\%", label="TATA PWM")
}
\seealso{
smoothHeatmap
}
