formatGenomicPosition <- function( x, unit = "Mb", divisor = 1000000, digits = 3, nsmall = 1 ){
  x = as.character(x)
  return(
    sapply(
      strsplit(x, split=":"),
      function(y) paste(
        format(
          as.numeric(y[1])/divisor,
          digits = digits,
          nsmall=nsmall), unit, sep = ""))
    )
}

encodeDNAString <- function( ds ){
  ret = log2(as.numeric(ds))
  ret[ !(ret %in% c(0,1,2,3)) ] = -1
  return(ret)
}

#This function is for postprocessing ensembl varaint predictor output
.mergeByGene <- function( df ){                                                                                                                                                                                   
  tmp <- bplapply( split(df, df$Gene), function(x){                                                                                                                                                            
    ret = x[1,]                                                                                                                                                                                              
    ret$SIFT = min(x$SIFT)                                                                                                                                                                                   
    ret$Consequence = paste( unique( sort( unlist( strsplit( x$Consequence, split = ",") ) ) ), collapse = ", " )                                                                                            
    ret                                                                                                                                                                                                      
  })                                                                                                                                                                                                           
  return(do.call(rbind, tmp))                                                                                                                                                                                  
}                                                                                                                                                                                                                
