% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindcadd_snv.R
\name{bindcadd_snv}
\alias{bindcadd_snv}
\title{bind CADD scores of Kircher et al. 2014 to a GRanges instance}
\usage{
bindcadd_snv(
  gr,
  fn = "http://krishna.gs.washington.edu/download/CADD/v1.0/1000G.tsv.gz"
)
}
\arguments{
\item{gr}{query ranges to which CADD scores should be bound}

\item{fn}{path to Tabix-indexed bgzipped TSV of CADD as distributed at
krishna.gs.washington.edu on 1 April 2014}
}
\value{
GRanges instance with additional fields as obtained in the CADD
resource
}
\description{
bind CADD scores of Kircher et al. 2014 to a GRanges instance; by default
will use HTTP access at UW
}
\details{
joins CADD fields at addresses that match query; the CADD fields for query
ranges that are not matched are set to NA
}
\note{
This software developed in part with support from Genentech, Inc.
}
\examples{

 \dontrun{
  data(ebicat_2020_04_30)
  g2 = as(ebicat_2020_04_30, "GRanges")
 # would need to lift over here 
  bindcadd_snv( g2[which(seqnames(g2)=="chr2")][1:20] )
  }

}
\references{
M Kircher, DM Witten, P Jain, BJ O'Roak, GM Cooper, J Shendure,
A general framework for estimating the relative pathogenicity of human
genetic variants, Nature Genetics Feb 2014, PMID 24487276
}
\author{
VJ Carey <stvjc@channing.harvard.edu>
}
\keyword{models}
