% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmoviz.R
\name{drawLinegraphTrack}
\alias{drawLinegraphTrack}
\title{Add a line graph track to an existing plot}
\usage{
drawLinegraphTrack(plot_data, track_border_colour = "black",
  track_height = 0.3, yaxis_increment = NULL, ylim = NULL,
  line_shade_colour = "#5ab4ac", line_colour = "black",
  yaxis_label_size = 0.5, show_yaxis = TRUE, yaxis_tick_size = 0.4,
  yaxis_side = "left", yaxis_colour = "black",
  yaxis_location = CELL_META$sector.index, show_gridlines = TRUE,
  gridline_colour = "#aaaaaa")
}
\arguments{
\item{plot_data}{Either: (1) a \linkS4class{GRanges} object with a metadata
column of y values to plot OR (2) a data frame with four columns; \code{chr}
(should match those supplied when initialising the plot); \code{start} and
\code{end} (x values of the point: can both be the same if you only have
a single x value for position) and then a fourth column of y values.}

\item{track_border_colour}{Colour of the border of the plotting region.}

\item{track_height}{The proportion (between 0 and 1) of the circle
taken up by this track.}

\item{yaxis_increment}{The increment the y axis and gridlines will use.}

\item{ylim}{Vector of length 2; upper and lower limits for y axis.}

\item{line_shade_colour}{The colour the will be used to fill in under the
line. Set this to NULL if you just want the line rather than the area.}

\item{line_colour}{The colour of the line itself.}

\item{yaxis_label_size}{Size of the labels on the y axis.}

\item{show_yaxis}{If \code{TRUE}, a y axis will be drawn.}

\item{yaxis_tick_size}{Size of the ticks on the y axis.}

\item{yaxis_side}{Side of the sector the y axis is on; either \code{'left'}
or \code{'right'}.}

\item{yaxis_colour}{Colour of the y axis.}

\item{yaxis_location}{Sector the y axis is drawn on.}

\item{show_gridlines}{If \code{TRUE} then gridlines will be drawn.}

\item{gridline_colour}{Colour of the gridlines.}
}
\value{
Adds a line graph track to existing visualisation.
}
\description{
Adds a line graph track to the existing plot. Must have
initialised the circular plot (by \code{\link{gmovizInitialise}} first).
}
\examples{
## you must initialise first!
small_ideo <- data.frame(chr=c('region 1', 'region 2', 'region 3'),
                         start=c(0, 0, 0), end=c(10000, 12000, 10000))
gmovizInitialise(small_ideo, custom_sector_width=c(0.3, 0.3, 0.3))

## make the data
smallplot_data <- data.frame(
chr = sample(c('region 1', 'region 2','region 3'), size=300, replace=TRUE),
start = seq(0, 10000, length.out=300), end = seq(0, 10000, length.out=300),
val = rnorm(300, 2, 0.5))
## line graph with no shading (just the line)
drawLinegraphTrack(smallplot_data, line_shade_colour=NULL)

## line graph with shading (a filled in shape)
drawLinegraphTrack(smallplot_data, line_shade_colour='#db009599')
}
\seealso{
\code{\link{gmovizInitialise}}, which must be used to initialise
the graph before this function. Also \code{\link{drawScatterplotTrack}} for
a similar function which displays data as a scatterplot rather than as a
line graph.
}
