% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_glycan_parse.R
\name{wurcs_to_tree}
\alias{wurcs_to_tree}
\title{Convert a WURCS string into a glycan tree structure}
\usage{
wurcs_to_tree(w)
}
\arguments{
\item{w}{A character string containing a WURCS 2.0 glycan annotation.}
}
\value{
A list with two elements:
\itemize{
  \item \code{node}: character vector of residue types in order
  \item \code{edge}: character vector of edges in "A-B" format
}
}
\description{
Parse a WURCS (WURCS 2.0) glycan annotation and extract:
\itemize{
  \item residue sequence (as a character vector)
  \item edge list (parent–child relationships)
}
}
\details{
This function is used internally to convert WURCS
strings into a tree representation that can support structural
trait computation and graph construction.


The function performs several parsing steps:
\enumerate{
  \item Remove the WURCS prefix and split the string into components.
  \item Extract \emph{UniqueRES} entries and map them to residue symbols
        using the internal \code{WURCS_RES_MAP} table.
  \item Follow the \emph{RES sequence} index to reconstruct the residue
        vector.
  \item Parse \emph{LIN} entries and normalize them into simple "X-Y" edges.
}
}
\examples{
# Example WURCS glycan string
w <- paste0(
  "WURCS=2.0/4,9,8/",
  "[u2122h_2*NCC/3=O]",
  "[a2122h-1b_1-5_2*NCC/3=O]",
  "[a1122h-1b_1-5]",
  "[a1122h-1a_1-5]",
  "/1-2-3-4-4-4-4-4-4/",
  "a4-b1_b4-c1_c3-d1_c6-f1_d2-e1_f3-g1_f6-h1_h2-i1"
)
tree <- wurcs_to_tree(w)
tree

}
