% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_glycan_parse.R
\name{pGlyco3_to_tree}
\alias{pGlyco3_to_tree}
\title{Convert a pGlyco3 glycan string into a glycan tree structure}
\usage{
pGlyco3_to_tree(expr)
}
\arguments{
\item{expr}{A character string representing the pGlyco3 glycan structure.}
}
\value{
A list with:
\itemize{
  \item \code{node}: character vector of residue types
  \item \code{edge}: character vector of edges in "a-b" format
}
}
\description{
Parse a pGlyco3-style glycan expression (e.g. \code{"N(H(H))"})
and reconstruct the residue sequence and edge relationships
as a tree suitable for downstream structural analysis. This parser assumes
simple pGlyco3 monosaccharide symbols (e.g. "N", "H", "A", "F").
}
\details{
This function interprets parentheses as branch delimiters and assigns:
\enumerate{
  \item one residue per character (e.g. \code{N}, \code{H}, \code{A})
  \item parent–child edges based on bracket nesting
}

Each residue is assigned a synthetic node label
(\code{a}, \code{b}, \code{c}, …), ensuring compatibility with
graph-based trait extraction.
}
\examples{
# Example: parse a pGlyco3-style glycan expression into a tree
pGlyco_expr <- "(N(N(H(H(H))(H(H)(H)(H(H))))))"
# Convert to glycan tree structure
tree <- pGlyco3_to_tree(pGlyco_expr)
tree

}
