# glycoTraitR <img src="man/figures/logo.png" style="float:right; height:140px;"/>

![R](https://img.shields.io/badge/R-glycoproteomics-blue?style=flat-square) ![license](https://img.shields.io/badge/license-MIT-green?style=flat-square)

## Introduction

**Glycoproteomics** is a rapidly expanding field, but analyzing the LC-MS data remains a complex, multi-step process. In [the post](https://lgatto.codeberg.page/death-research-software/), Laurent emphasizes that software is a central player in scientific research. Here is his simple but powerful equation:

> **Experimental design + data + software = results**

For glycoproteomics data, advanced search engines such as Byonic, MSFragger, pGlyco3, Glyco-Decipher, and StructGP are indispensable for identifying glycopeptides. However, identification alone is not the end of the workflow.

Researchers need downstream analytical tools to: interpret glycan structural features, quantify glycan heterogeneity, compare biological groups, and extract mechanistic insight.

To address this need, we developed **glycoTraitR**, an R package that extends the analysis capability to the glycoproteomics context:

> **Software = Software (search engine) + Software (analysis tool, e.g., glycoTraitR)**

glycoTraitR is designed for users who want to go beyond simple differential analysis, extracting, summarizing, and analyzing glycan structural traits from GPSM data generated by **pGlyco3** or **Glyco-Decipher**.

It provides a streamlined workflow for:

-   parsing WURCS 2.0 and pGlyco3 glycan strings
-   computing composition & structural traits
-   summarizing glycan–PSM trait matrices at site/protein level (`SummarizedExperiment`)
-   performing differential trait analysis and visualizing trait changes

------------------------------------------------------------------------

## Download Package

``` r
if (!require("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("matsui-lab/glycoTraitR")
```

## Package Workflow

``` text
  pGlyco3 / Decipher GPSM
            │
            ▼
   Parse glycan strings
            │
            ▼
 Compute glycan traits (composition + structure)
            │
            ▼
 SummarizedExperiment (trait × PSM)
            │
            ▼
 Differential analysis & plots
```

------------------------------------------------------------------------

## Questions and collaboration

For questions or collaboration, feel free to contact me! Contributions are welcome!
