% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{intern.chromo}
\alias{intern.chromo}
\title{Internal function}
\usage{
intern.chromo(Y, Ystart, Yend, X, Xloc,
             window, offset, group, perm,
             nodes, phi, kind)
}
\arguments{
\item{Y}{RNA-Seq data\strong{:}
numeric matrix with \code{q} rows (genes)
and \code{n} columns (samples);
or a SummarizedExperiment object}

\item{Ystart}{start location of genes\strong{:}
numeric vector of length \code{q}}

\item{Yend}{end location of genes\strong{:}
NULL or numeric vector of length \code{q}}

\item{X}{genomic profile\strong{:}
numeric matrix with \code{p} rows (covariates)
and \code{n} columns (samples)}

\item{Xloc}{location covariates\strong{:}
numeric vector of length \code{p}}

\item{window}{maximum distance\strong{:}
non-negative real number}

\item{offset}{numeric vector of length \code{n}}

\item{group}{confounding variable\strong{:}
factor of length \code{n}}

\item{perm}{number of iterations\strong{:}
positive integer}

\item{nodes}{number of cluster nodes for parallel computation}

\item{phi}{dispersion parameters\strong{:} vector of length \code{q}}

\item{kind}{computation \strong{:}
number between 0 and 1}
}
\value{
The function returns a dataframe,
with the p-value in the first column,
and the test statistic in the second column.
}
\description{
Communicates between \code{\link{cursus}} and \code{\link{omnibus}}
by coordinating a chromosome-wide analysis.
}
\examples{
# simulate high-dimensional data
n <- 30
q <- 10
p <- 100
set.seed(1)
Y <- matrix(rnbinom(q*n,mu=10,
    size=1/0.25),nrow=q,ncol=n)
X <- matrix(rnorm(p*n),nrow=p,ncol=n)
Yloc <- seq(0,1,length.out=q)
Xloc <- seq(0,1,length.out=p)
window <- 1

# hypothesis testing
cursus(Y,Yloc,X,Xloc,window)

}
\keyword{internal}
