% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_sparse_net.R, R/glm_degree.R, R/glm_hub.R,
%   R/glm_orphan.R
\name{glmSparseNet}
\alias{glmSparseNet}
\alias{glmDegree}
\alias{glmHub}
\alias{glmOrphan}
\title{Calculate GLM model with network-based regularization}
\usage{
glmSparseNet(
  xdata,
  ydata,
  network,
  options = networkOptions(),
  experiment = NULL,
  network.options = deprecated(),
  experiment.name = deprecated(),
  ...
)

glmDegree(
  xdata,
  ydata,
  network,
  options = networkOptions(),
  experiment = NULL,
  network.options = deprecated(),
  experiment.name = deprecated(),
  ...
)

glmHub(
  xdata,
  ydata,
  network,
  options = networkOptions(),
  experiment = NULL,
  network.options = deprecated(),
  experiment.name = deprecated(),
  ...
)

glmOrphan(
  xdata,
  ydata,
  network,
  options = networkOptions(),
  experiment = NULL,
  network.options = deprecated(),
  experiment.name = deprecated(),
  ...
)
}
\arguments{
\item{xdata}{input data, can be a matrix or MultiAssayExperiment.}

\item{ydata}{response data compatible with glmnet.}

\item{network}{type of network, see below.}

\item{options}{options to calculate network.}

\item{experiment}{name of experiment to use as input in
MultiAssayExperiment object (only if xdata is an object of this class).}

\item{network.options}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{experiment.name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{...}{parameters that \code{\link[glmnet:glmnet]{glmnet::glmnet()}} accepts.}
}
\value{
an object just as glmnet
}
\description{
network parameter accepts:
\itemize{
\item string to calculate network based on data (correlation, covariance)
\item matrix representing the network
\item vector with already calculated penalty weights (can also be used directly
with glmnet)
}
}
\section{Functions}{
\itemize{
\item \code{glmDegree()}: penalizes nodes with small degree
\emph{(inversion penalization \code{h(x) = 1 / x})}.

\item \code{glmHub()}: Penalizes nodes with small degree
\emph{(normalized heuristic that promotes nodes with many edges)}.

\item \code{glmOrphan()}: Penalizes nodes with high degree
\emph{(normalized heuristic that promotes nodes with few edges)}.

}}
\examples{
xdata <- matrix(rnorm(100), ncol = 20)
glmSparseNet(xdata, rnorm(nrow(xdata)), "correlation", family = "gaussian")
glmSparseNet(xdata, rnorm(nrow(xdata)), "covariance", family = "gaussian")

\dontshow{if (requireNamespace("MultiAssayExperiment", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
#
#
# Using MultiAssayExperiment
# load data
library(MultiAssayExperiment)
data("miniACC", package = "MultiAssayExperiment")

xdata <- miniACC
# TODO aking out x individuals missing values
# build valid data with days of last follow up or to event
event.ix <- which(!is.na(xdata$days_to_death))
cens.ix <- which(!is.na(xdata$days_to_last_followup))

xdata$surv_event_time <- array(NA, nrow(colData(xdata)))
xdata$surv_event_time[event.ix] <- xdata$days_to_death[event.ix]
xdata$surv_event_time[cens.ix] <- xdata$days_to_last_followup[cens.ix]

# Keep only valid individuals
valid.ix <- as.vector(!is.na(xdata$surv_event_time) &
    !is.na(xdata$vital_status) &
    xdata$surv_event_time > 0)
xdata.valid <- xdata[, rownames(colData(xdata))[valid.ix]]
ydata.valid <- colData(xdata.valid)[, c("surv_event_time", "vital_status")]
colnames(ydata.valid) <- c("time", "status")

glmSparseNet(
    xdata.valid,
    ydata.valid,
    family = "cox",
    network = "correlation",
    experiment = "RNASeq2GeneNorm"
)
\dontshow{\}) # examplesIf}
# Degree penalization

xdata <- matrix(rnorm(100), ncol = 5)
glmDegree(
    xdata,
    rnorm(nrow(xdata)),
    "correlation",
    family = "gaussian",
    options = networkOptions(minDegree = .2)
)
xdata <- matrix(rnorm(100), ncol = 5)
glmHub(
    xdata,
    rnorm(nrow(xdata)),
    "correlation",
    family = "gaussian",
    options = networkOptions(minDegree = .2)
)
# Orphan penalization

xdata <- matrix(rnorm(100), ncol = 5)
glmOrphan(
    xdata,
    rnorm(nrow(xdata)),
    "correlation",
    family = "gaussian",
    options = networkOptions(minDegree = .2)
)
}
\seealso{
Cross-validation functions \code{\link[=cv.glmSparseNet]{cv.glmSparseNet()}}.
}
