% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_point.R
\name{geom_rootpoint}
\alias{geom_rootpoint}
\title{geom_rootpoint}
\usage{
geom_rootpoint(
  mapping = NULL,
  data = NULL,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mapping created by \code{aes()}.
If \code{inherit.aes = TRUE}, the mapping can be inherited from the plot mapping as
specified in the call to \code{ggplot()}.}

\item{data}{The data to be displayed in this layer. If 'NULL' (the default),
the data is inherited from the plot data as specified in the call to \code{ggplot()}.}

\item{position}{Position adjustment.}

\item{na.rm}{logical. If 'FALSE' (default), missing values are removed with a warning. If 'TRUE', missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
'NA', the default, includes if any aesthetics are mapped. 'FALSE' never includes, and 'TRUE' always includes.}

\item{inherit.aes}{logical (defaults to 'TRUE'). If 'FALSE', overrides the default aesthetics,
rather then combining with them.}

\item{...}{addtional parameters that passed on to this layer. These are often aesthetics, used to set an aesthetic to a fixed value, like \code{colour = "red"} or \code{size = 3}.}
}
\value{
root point layer
}
\description{
geom_rootpoint is used to add root point layer to a tree
}
\details{
geom_rootpoint inherit from geom_point2, and it is used to display and customize the points on the root
}
\examples{
library(ggtree)
tr <- rtree(10)
##  add root point
ggtree(tr) + geom_rootpoint()
ggtree(tr) + geom_rootpoint(size=2,color="red",shape=2)
}
\references{
\enumerate{
\item Guangchuang Yu. Using ggtree to visualize data on tree-like structures. Current Protocols in Bioinformatics. 2020, 69:e96. doi:10.1002/cpbi.96
\item Guangchuang Yu, Tommy Tsan-Yuk Lam, Huachen Zhu, Yi Guan. Two methods for mapping and visualizing associated data on phylogeny using ggtree. Molecular Biology and Evolution. 2018, 35(12):3041-3043. doi:10.1093/molbev/msy194
\item Guangchuang Yu, David Smith, Huachen Zhu, Yi Guan, Tommy Tsan-Yuk Lam. ggtree: an R package for visualization and annotation of phylogenetic trees with their covariates and other associated data. Methods in Ecology and Evolution. 2017, 8(1):28-36. doi:10.1111/2041-210X.12628
}

For more information, please refer to the online book:Data Integration, Manipulation and Visualization of Phylogenetic Trees.\url{http://yulab-smu.top/treedata-book/}
}
\seealso{
\link[ggplot2:geom_point]{geom_point};
\link{geom_rootpoint} add point of root;
\link{geom_nodepoint} add points of internal nodes;
\link{geom_tippoint} add points of external nodes (also known as tips or leaves).
}
\author{
Guangchuang Yu
}
