% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc-violin.R
\name{sc_violin}
\alias{sc_violin}
\alias{sc_violin,Seurat-method}
\alias{sc_violin,Seurat}
\alias{sc_violin,SingleCellExperiment-method}
\alias{sc_violin,SingleCellExperiment}
\title{sc_violin}
\usage{
sc_violin(
  object,
  features,
  cells = NULL,
  slot = "data",
  .fun = NULL,
  mapping = NULL,
  ncol = 3,
  geom = geom_violin,
  ...
)

\S4method{sc_violin}{Seurat}(
  object,
  features,
  cells = NULL,
  slot = "data",
  .fun = NULL,
  mapping = NULL,
  ncol = 3,
  geom = geom_violin,
  ...
)

\S4method{sc_violin}{SingleCellExperiment}(
  object,
  features,
  cells = NULL,
  slot = "data",
  .fun = NULL,
  mapping = NULL,
  ncol = 3,
  geom = geom_violin,
  ...
)
}
\arguments{
\item{object}{Seurat object}

\item{features}{selected features}

\item{cells}{selected cells to plot (default is all cells)}

\item{slot}{slot to pull expression data from (e.g., 'count' or 'data')}

\item{.fun}{user defined function that will be applied to selected features (default is NULL and there is no data operation)}

\item{mapping}{aesthetic mapping}

\item{ncol}{number of facet columns if 'length(features) > 1'}

\item{geom}{the geom function, default is geom_violin, other option is geom_boxplot}

\item{...}{additional parameters pass to 'ggplot2::geom_geom_violin()'}
}
\value{
violin plot to visualize feature expression distribution
}
\description{
sc_violin
}
\examples{
library(scuttle)
library(scater)
library(scran)
library(ggplot2)
sce <- mockSCE()
sce <- logNormCounts(sce)
clusters <- clusterCells(sce, assay.type = 'logcounts')
colLabels(sce) <- clusters
sce <- runUMAP(sce, assay.type = 'logcounts')
set.seed(123)
genes <- rownames(sce) |> sample(6) 
sc_violin(sce, genes[1], slot = 'logcounts')
sc_violin(sce, genes[1], slot = 'logcounts',
     .fun=function(d) dplyr::filter(d, value > 0)
     ) +
     ggforce::geom_sina(size=.1)
sc_violin(sce, genes, slot = 'logcounts') +
  theme(axis.text.x = element_text(angle=45, hjust=1))
}
\seealso{
\link[ggplot2:geom_violin]{geom_violin};
}
