% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcyto_GatingLayout.R
\name{ggcyto_arrange}
\alias{ggcyto_arrange}
\title{Arrange a list of ggplot objects into gtable}
\usage{
ggcyto_arrange(x, ...)
}
\arguments{
\item{x}{ggcyto_gate_layout, which is essentially a list of ggplot objects that were previously stored as ggcyto_gate_layout object by autoplot function.}

\item{...}{other arguments passed to arrangeGrob}
}
\value{
gtable
}
\description{
It is usually implicitly invoked by print and show method and can be called by user when the further manipulation is needed,
}
\examples{
\dontrun{
# get ggcyto_GatingLayout object from first sample
res <- autoplot(gs[[1]], nodes, bins = 64)
class(res)
# arrange it as one-row gtable object 
gt <- ggcyto_arrange(res, nrow = 1)
gt
# do the same to the second sample
gt2 <- ggcyto_arrange(autoplot(gs[[2]], nodes, bins = 64), nrow = 1)
# combine the two and print it on the sampe page
gt3 <- gridExtra::gtable_rbind(gt, gt2)
plot(gt3)
}
}
