% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiles.R
\docType{data}
\name{geva.quantiles}
\alias{geva.quantiles}
\alias{options.quantiles}
\title{GEVA Quantiles Detection}

\usage{
geva.quantiles(
  sv,
  quantile.method = options.quantiles,
  initial.thresholds = c(S = NA_real_, V = NA_real_),
  nq.s = 3L,
  nq.v = 2L,
  comb.score.fn = prod,
  ...
)

options.quantiles
# c("range.slice", "proportional", "density", "k.max.sd", 
#   "custom")
}
\arguments{
\item{sv}{a \code{\linkS4class{SVTable}} object (usually \code{\linkS4class{GEVASummary}})}

\item{quantile.method}{\code{character}, method to detect the initial quantile thresholds. Ignored if \code{initial.thresholds} is specified with no \code{NA} elements}

\item{initial.thresholds}{named \code{numeric} vector with the threshold that delimits the initial quantile}

\item{nq.s}{\code{integer}, number of quantiles in S-axis (experimental, see `Note')}

\item{nq.v}{\code{integer}, number of quantiles in V-axis (experimental, see `Note')}

\item{comb.score.fn}{\code{function} applied to merge \code{S} and \code{V} score columns into a single column. The function must require only one argument of \verb{numeric vector} type and return a single \code{numeric} value. Examples include \code{prod} or \code{mean}}

\item{...}{additional arguments include:
\itemize{
\item{\code{qslice} : \code{numeric} (\code{0} to \code{1}), the axis fraction used by \code{"range.slice"} and \code{"density"} methods (see 'Details'). Default is \code{0.25}}
\item{\code{k} : \code{integer}, neighbor points used by \code{"density"} and \code{"k.max.sd"} methods (see 'Details'). Default is \code{16}}
\item{\code{verbose} : \code{logical}, whether to print the current progress. Default is \code{TRUE}}
}}
}
\description{
Calculates the quantiles of a \code{\linkS4class{SVTable}}.
}
\details{
The \code{quantile.method} defines how the initial quantile (usually the one at the bottom center) is calculated. Each method has a specific way to estimate the first spatial delimiter, as described below:
\describe{
\item{\code{"range.slice"} (default)}{Separation is set at the nearest point to a fraction of the spatial range. This fraction can be specified by the \code{qslice} optional argument (\code{numeric}, default is 0.25, or 25\%);}
\item{\code{"density"}}{Separation is set at the point with the most proportional density by \emph{k} neighbor points to its current spatial fraction. This method uses the optional arguments \code{qslice} (\code{numeric}, default is 0.25, or 25\%) for the desired spatial fraction, and \code{k} (\code{numeric}, default is \code{16}) for the number of neighbor points;}
\item{\code{"k.max.sd"}}{Separation is set at the point with the greatest standard deviation of distance to its \emph{k} neighbor points. The number of neighbor points can be specified by the \code{k} optional argument (\code{numeric}, default is \code{16});}
\item{\code{"proportional"}}{Separation is set at the exact axis division so that all quantiles have the size;}
\item{\code{"custom"}}{Uses the values specified in the \code{initial.thresholds} argument.}
}

A custom initial separation point can be specified in the \code{initial.thresholds} as a \code{numeric} vector of two elements, where the first element refers to \code{S} axis and the second, to \code{V} axis. If one of the elements is \code{NA}, the initial quantile is calculated for that axis only. If both values are not \code{NA}, the quantile separation method is ignored and automatically set to \code{"custom"}.

The \code{nq.s} and \code{nq.v} arguments determine the number of quantiles for the \code{S} and \code{V} axes, respectively. These parameters can be used to increase the number of possible partitions in the SV space, but their applicability is currently being tested (see `Note').

The \code{comb.score.fn} is a function applied to the partial scores for each SV point to combine them into a single value. The result value is defined as the "quantile score" for a SV point. The function is applied iteratively to two-element \code{numeric} vectors.
}
\note{
Customizing the number of quantiles by \code{nq.s} and \code{nq.v} is a \strong{experimental feature} and the remaining analysis steps are mostly based on the default parameters for these arguments. Tests are being conducted to determine this feature's applicability for the next releases.
}
\examples{
## Quantile detection from a randomly generated input 

# Preparing the data
ginput <- geva.ideal.example()      # Generates a random input example
gsummary <- geva.summarize(ginput)  # Summarizes with the default parameters

# Default usage
gquants <- geva.quantiles(gsummary) # Detects the quantiles
plot(gquants)                       # Plots the quantiles

# Custom initial delimiters
gquants <- geva.quantiles(gsummary,
                          initial.thresholds = c(S=1.00, V=0.5))
plot(gquants)                       # Plots the quantiles

# Quantile detection using densities
gquants <- geva.quantiles(gsummary, quantile.method = 'density')
plot(gquants)                       # Plots the quantiles

}
\seealso{
\link{geva.cluster}

Other geva.cluster: 
\code{\link{geva.cluster}()},
\code{\link{geva.dcluster}()},
\code{\link{geva.hcluster}()}
}
\concept{geva.cluster}
\keyword{datasets}
