% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_SVAttribute.R
\docType{class}
\name{SVAttribute-class}
\alias{SVAttribute-class}
\alias{SVAttribute}
\alias{SVNumAttribute}
\alias{SVIntAttribute}
\alias{SVChrAttribute}
\alias{SVNumAttribute-class}
\alias{SVIntAttribute-class}
\alias{SVChrAttribute-class}
\alias{show,SVAttribute-method}
\alias{[,SVAttribute,ANY,ANY,ANY-method}
\alias{$,SVAttribute-method}
\alias{dim,SVAttribute-method}
\alias{names,SVAttribute-method}
\alias{sv,SVAttribute-method}
\alias{svattr,character,character-method}
\alias{svattr,numeric,numeric-method}
\alias{svattr,integer,integer-method}
\alias{sv.data,SVAttribute-method}
\alias{summary.SVAttribute}
\alias{variation.SVAttribute}
\alias{as.character.SVAttribute}
\alias{as.vector.SVAttribute}
\title{Summary-Variation Attribute Field}

\arguments{
\item{S}{the \emph{summary} value}

\item{V}{the \emph{variation} value}
}
\value{
A \code{\linkS4class{SVAttribute}} object
}
\description{
This S4 class stores two character slots representing attribute fields for summary and variation. The \code{SVAttribute} class is abstract and must be instantiated as \code{SVChrAttribute} (for \code{character}), \code{SVNumAttribute} (for \code{numeric}), or \code{SVIntAttribute} (for \code{integer}).
}
\section{Slots}{

\describe{
\item{\code{S}}{either \code{character} or \code{numeric} or \code{integer} of length one}

\item{\code{V}}{either \code{character} or \code{numeric} or \code{integer} of length one}
}}

\note{
The slots \code{S} and \code{V} must be of the same class (either \code{character}, \code{numeric}, or \code{integer}).
}
\section{Methods}{

\sspace\cr\strong{Alternative accessors}
\describe{
\item{\code{summary(object, ...)}}{Returns the contents from \code{S} slot}
\item{\code{sv(object)}}{Returns the contents as a named vector}
\item{\code{variation(object, ...)}}{Returns the contents from \code{S} slot}
}
\sspace\cr\strong{Constructors}
\describe{
\item{\code{sv.data(object)}}{For internal use. Returns the equivalent object}
\item{\code{svattr(S, V)}}{Creates a new \code{SVAttribute}}
}
\sspace\cr\strong{Conversion and coercion}
\describe{
\item{\code{as.character(x, ...)}}{Converts this object to \code{character}}
\item{\code{as.vector(x, ...)}}{Converts this object to \code{vector}}
}
\sspace\cr\strong{Dimension accessors}
\describe{
\item{\code{dim(x)}}{For internal use, always returns \code{NULL}}
\item{\code{names(x)}}{Returns the slot names (always \code{c('S', 'V')})}
}
\sspace\cr\strong{Properties}
\describe{
\item{\code{x$name <- value}}{Queries the vector contents (equivalent to the indexer). Only accepts \verb{$S} and \verb{$V}}
\item{\code{x[i, j, ..., drop=TRUE]}}{Indexer to access the vector values. Only accepts \code{'S'} or \code{'V'} as \code{i} arguments}
}
}

