% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovcAngiogenic.R
\name{ovcAngiogenic}
\alias{ovcAngiogenic}
\title{Function to compute the subtype scores and risk classifications
for the angiogenic molecular subtype in ovarian cancer}
\usage{
ovcAngiogenic(data, annot, hgs,
gmap = c("entrezgene", "ensembl_gene_id", "hgnc_symbol", "unigene"),
do.mapping = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{Matrix of gene expressions with samples in rows and probes in
columns, dimnames being properly defined.}

\item{annot}{Matrix of annotations with one column named as gmap, dimnames
being properly defined.}

\item{hgs}{vector of booleans with TRUE represents the ovarian cancer
patients who have a high grade, late stage, serous tumor, FALSE otherwise. This is particularly important for properly rescaling the data. If hgs is missing, all the patients will be used to rescale the subtype score.}

\item{gmap}{character string containing the biomaRt attribute to use for
mapping if do.mapping=TRUE}

\item{do.mapping}{TRUE if the mapping through Entrez Gene ids must be
performed (in case of ambiguities, the most variant probe is kept for each gene), FALSE otherwise.}

\item{verbose}{TRUE to print informative messages, FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item score: Continuous signature scores.
\item risk: Binary risk classification, 1 being high risk and 0 being low risk.
\item mapping: Mapping used if necessary.
\item probe: If mapping is performed, this matrix contains the correspondence
between the gene list (aka signature) and gene expression data.
\item subtype: data frame reporting the subtype score, maximum likelihood
classification and corresponding subtype probabilities.
}
}
\description{
This function computes subtype scores and risk classifications from
gene expression values following the algorithm developed by Bentink,
Haibe-Kains et al. to identify the angiogenic molecular subtype in
ovarian cancer.
}
\examples{
# load the ovcAngiogenic signature

# load NKI dataset
data(nkis)
colnames(annot.nkis)[is.element(colnames(annot.nkis), "EntrezGene.ID")] <- 
  "entrezgene"

# compute relapse score
ovcAngiogenic.nkis <- ovcAngiogenic(data=data.nkis, annot=annot.nkis,
  gmap="entrezgene", do.mapping=TRUE)
table(ovcAngiogenic.nkis$risk)

}
\references{
Bentink S, Haibe-Kains B, Risch T, Fan J-B, Hirsch MS, Holton K, Rubio R,
April C, Chen J, Wickham-Garcia E, Liu J, Culhane AC, Drapkin R, Quackenbush
JF, Matulonis UA (2012) "Angiogenic mRNA and microRNA Gene Expression
Signature Predicts a Novel Subtype of Serous Ovarian Cancer", PloS one,
7(2):e30269
}
\seealso{
\link{sigOvcAngiogenic}
}
