% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genius.R
\name{genius}
\alias{genius}
\title{Function to compute the Gene Expression progNostic Index Using Subtypes (GENIUS)
as published by Haibe-Kains et al. 2010}
\usage{
genius(data, annot, do.mapping = FALSE, mapping, do.scale = TRUE)
}
\arguments{
\item{data}{Matrix of gene expressions with samples in rows and probes in columns,
dimnames being properly defined.}

\item{annot}{Matrix of annotations with at least one column named "EntrezGene.ID",
dimnames being properly defined.}

\item{do.mapping}{TRUE if the mapping through Entrez Gene ids must be performed (in case of ambiguities,
the most variant probe is kept for each gene), FALSE otherwise.}

\item{mapping}{Matrix with columns "EntrezGene.ID" and "probe" used to force the
mapping such that the probes are not selected based on their variance.}

\item{do.scale}{TRUE if the ESR1, ERBB2 and AURKA (module) scores must be rescaled
(see rescale), FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item GENIUSM1: Risk score from the ER-/HER2- subtype signature in GENIUS model.
\item GENIUSM2: Risk score from the HER2+ subtype signature in GENIUS model.
\item GENIUSM3: Risk score from the ER+/HER2- subtype signature in GENIUS model.
\item score: Overall risk prediction as computed by the GENIUS model.a.
}
}
\description{
This function computes the Gene Expression progNostic Index Using Subtypes (GENIUS)
as published by Haibe-Kains et al. 2010. Subtype-specific risk scores are computed for
each subtype signature separately and an overall risk score is computed by combining
these scores with the posterior probability to belong to each of the breast cancer
molecular subtypes.
}
\examples{
# load NKI dataset
data(nkis)
data(scmod1.robust)
data(sig.genius)

# compute GENIUS risk scores based on GENIUS model fitted on VDX dataset
genius.nkis <- genius(data=data.nkis, annot=annot.nkis, do.mapping=TRUE)
str(genius.nkis)
# the performance of GENIUS overall risk score predictions are not optimal
# since only part of the NKI dataset was used

}
\references{
Haibe-Kains B, Desmedt C, Rothe F, Sotiriou C and Bontempi G (2010) "A fuzzy gene
expression-based computational approach improves breast cancer prognostication", Genome Biology, 11(2):R18
}
\seealso{
\link{subtype.cluster.predict},\link{sig.score}
}
