% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.pairw.cor.z.R
\name{compute.pairw.cor.z}
\alias{compute.pairw.cor.z}
\title{Function to compute the Z transformation of the pairwise
correlations for a list of datasets}
\usage{
compute.pairw.cor.z(datas, method = c("pearson"))
}
\arguments{
\item{datas}{List of datasets. Each dataset is a matrix of gene expressions with samples in
rows and probes in columns, dimnames being properly defined. All the datasets must have
the same probes.}

\item{method}{Estimator for correlation coefficient, can be either pearson or spearman.}
}
\value{
A list with items:
-z Z transformation of the meta-estimate of correlation coefficients.
-se Standard error of the Z transformation of the meta-estimate of
correlation coefficients.
-nn Number of samples used to compute the meta-estimate of correlation coefficients.
}
\description{
This function computes the Z transformation of the meta-estimate of pairwise correlation
coefficients for a set of genes from a list of gene expression datasets.
}
\seealso{
\link{map.datasets}, \link{compute.pairw.cor.meta}, \link{compute.proto.cor.meta}
}
