% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.proto.cor.R
\name{compareProtoCor}
\alias{compareProtoCor}
\title{Function to statistically compare correlation to prototypes}
\usage{
compareProtoCor(gene.cor, proto.cor, nn,
 p.adjust.m = c("none", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr"))
}
\arguments{
\item{gene.cor}{Correlation coefficients between the probes and each of the prototypes.}

\item{proto.cor}{Pairwise correlation coefficients of the prototypes.}

\item{nn}{Number of samples used to compute the correlation coefficients between
the probes and each of the prototypes.}

\item{p.adjust.m}{Correction method as defined in p.adjust.}
}
\value{
Data frame with probes in rows and with three columns:
"proto" is the prototype to which the probe is the most correlated,
"cor" is the actual correlation, and "signif" is the (corrected) p-value
for the superiority of the correlation to this prototype compared to the
second highest correlation.
}
\description{
This function performs a statistical comparison of the correlation
coefficients as computed between each probe and prototype.
}
\examples{
# load VDX dataset
data(vdxs)
# load NKI dataset
data(nkis)
# reduce datasets
ginter <- intersect(annot.vdxs[ ,"EntrezGene.ID"], annot.nkis[ ,"EntrezGene.ID"])
ginter <- ginter[!is.na(ginter)][1:30]
myx <- unique(c(match(ginter, annot.vdxs[ ,"EntrezGene.ID"]),
  sample(x=1:nrow(annot.vdxs), size=20)))
data2.vdxs <- data.vdxs[ ,myx]
annot2.vdxs <- annot.vdxs[myx, ]
myx <- unique(c(match(ginter, annot.nkis[ ,"EntrezGene.ID"]),
sample(x=1:nrow(annot.nkis), size=20)))
data2.nkis <- data.nkis[ ,myx]
annot2.nkis <- annot.nkis[myx, ]
# mapping of datasets
datas <- list("VDX"=data2.vdxs,"NKI"=data2.nkis)
annots <- list("VDX"=annot2.vdxs, "NKI"=annot2.nkis)
datas.mapped <- map.datasets(datas=datas, annots=annots, do.mapping=TRUE)
# define some prototypes
protos <- paste("geneid", ginter[1:3], sep=".")
# compute meta-estimate of correlation coefficients to the three prototype genes
probecor <- compute.proto.cor.meta(datas=datas.mapped$datas, proto=protos,
  method="pearson")
# compute meta-estimate of pairwise correlation coefficients between prototypes
datas.proto <- lapply(X=datas.mapped$datas, FUN=function(x, p) {
  return(x[ ,p,drop=FALSE]) }, p=protos)
protocor <- compute.pairw.cor.meta(datas=datas.proto, method="pearson")
# compare correlation coefficients to each prototype
res <- compareProtoCor(gene.cor=probecor$cor, proto.cor=protocor$cor,
nn=probecor$cor.n, p.adjust.m="fdr")
head(res)

}
\seealso{
\link{compute.proto.cor.meta}, \link{compute.pairw.cor.meta}
}
