% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_lookup.r
\name{gene_lookup}
\alias{gene_lookup}
\title{Looks up specific gene and closest peaks}
\usage{
gene_lookup(organism, gene_name, n = 2, extension = NA, cutoff = Inf)
}
\arguments{
\item{organism}{Object name assigned from readGFF() command.}

\item{gene_name}{Gene names or gene ids specified by user in a string form.}

\item{n}{Number of closest peaks located to `gene_name` on any given chromosome to be found. Default = 2}

\item{extension}{Desired upstream extension. If left unspecified, the latest geneXtender bed file will be chosen. If no extension is specified and no bed file can be found, a default extension of 500 is selected.}

\item{cutoff}{Optional arg to specify max bp distance to search around `gene_name`. Default = Inf}
}
\value{
A data.table with all peaks located within `n` peaks and `cutoff` bp distance away on every chromosome that contains `gene_name`.
}
\description{
Looks up closest peak to a specified gene on the peaks file (which has been preprocessed with the peaksInput() command) based on the latest .bed file accessed or for a specified extension.  This command requires a preprocessed "peaks.txt" file (generated using peaksInput()) to be present in the user's working directory, otherwise the user is prompted to rerun the peaksInput() command in order to regenerate it.
}
\examples{
library(rtracklayer)
rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz")
fpath <- system.file("extdata", "somepeaksfile.txt", package="geneXtendeR")
closest <- gene_lookup(rat, c("Vom2r3", "Vom2r5"), n = 7, extension = 1000)
closest

}
