% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{methods}
\name{showClassifierList}
\alias{showClassifierList}
\title{Show classifier names and descriptions.}
\usage{
showClassifierList(normalizations)
}
\arguments{
\item{normalizations}{an optional text argument of one or more normalization methods in order to filter the classifiers to be shown.}
}
\value{
A data.frame with columns: "name","normalizationMethod" and "description"
}
\description{
\code{showClassifierList} gives a data.frame of all implemented classifiers.
}
\details{
The names of the classifiers shown can be used as input for the \code{\link{runClassifier}} function and the \code{\link{getClassifier}} function.
}
\examples{
showClassifierList()
data(exampleMAS5)
myData <- setNormalizationMethod(exampleMAS5, "MAS5.0",targetValue=500)
results <- runClassifier('UAMS70', myData)
getScores( results )
getClassifications( results )

}
\seealso{
Other workflow functions: \code{\link{getNormalizationMethod}},
  \code{\link{runClassifier}},
  \code{\link{setNormalizationMethod}}
}
\concept{workflow functions}
