% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierResults.R, R/zzz.R
\docType{methods}
\name{getClassifier}
\alias{getClassifier}
\alias{getClassifier,ClassifierResults-method}
\alias{getClassifier,character-method}
\title{Obtain a classifier definition.}
\usage{
getClassifier(value)

\S4method{getClassifier}{ClassifierResults}(value)

\S4method{getClassifier}{character}(value)
}
\arguments{
\item{value}{Either a text value indicating a classifier name
(see \code{\link{showClassifierList}}), or an object of
class \code{\link{ClassifierResults}} as returned by the
\code{\link{runClassifier}} function.}
}
\value{
The return value is a classifier definition which
is encoded in an object of class \code{\link{ClassifierParameters}}.
This can be used as input argument for the \code{\link{runClassifier}}
function.
}
\description{
\code{getClassifier} returns a requested classifier definition.
}
\examples{
getClassifier("EMC92")
}
\seealso{
\code{\link{ClassifierParameters}} and \code{\link{runClassifier}}

Other classifier information functions: \code{\link{getCitations}},
  \code{\link{getDecisionBoundaries}},
  \code{\link{getDescription}},
  \code{\link{getEventChain}}, \code{\link{getIntercept}},
  \code{\link{getMeans}},
  \code{\link{getNormalizationMethod}},
  \code{\link{getProbeNames}}, \code{\link{getSds}},
  \code{\link{getTrainingData}}, \code{\link{getWeights}}
}
\concept{classifier information functions}
