% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processors.R
\name{processElements}
\alias{processElements}
\title{Processes JSON as a vector of elements}
\usage{
processElements(d)
}
\arguments{
\item{d}{The JSON to process}
}
\value{
A data table with information about the probes representing a gene across
all platrofms. A list if \code{raw = TRUE}.
A \code{404 error} if the given identifier does not map to any genes.

The fields of the output data.table are:

\itemize{
\item \code{element.name}: Name of the element. Typically the probeset name
\item \code{element.description}: A free text field providing optional information about the element
\item \code{platform.shortName}: Shortname of the platform given by Gemma. Typically the GPL identifier.
\item \code{platform.name}: Full name of the platform
\item \code{platform.ID}: Id number of the platform given by Gemma
\item \code{platform.type}: Type of the platform.
\item \code{platform.description}: Free text field describing the platform.
\item \code{platform.troubled}: Whether the platform is marked as troubled by a Gemma curator.
\item \code{taxon.name}: Name of the species platform was made for
\item \code{taxon.scientific}: Scientific name for the taxon
\item \code{taxon.ID}: Internal identifier given to the species by Gemma
\item \code{taxon.NCBI}: NCBI ID of the taxon
\item \code{taxon.database.name}: Underlying database used in Gemma for the taxon
\item \code{taxon.database.ID}: ID of the underyling database used in Gemma for the taxon
}
}
\description{
Processes JSON as a vector of elements
}
\keyword{internal}
