% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{get_gene_locations}
\alias{get_gene_locations}
\title{Retrieve the physical locations of a given gene}
\usage{
get_gene_locations(
  gene,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{gene}{An ensembl gene identifier which typically starts with ensg or an ncbi gene identifier or an official gene symbol approved by hgnc}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data table with information about the physical location of the
queried gene. A list if \code{raw = TRUE}. A \code{404 error} if the given identifier does not map to any object.

The fields of the output data.table are:

\itemize{
\item \code{chromosome}: Name of the chromosome the gene is located
\item \code{strand}: Which strand the gene is located
\item \code{nucleotide}: Nucleotide number for the gene
\item \code{length}: Gene length
\item \code{taxon.name}: Name of the taxon
\item \code{taxon.scientific}: Scientific name for the taxon
\item \code{taxon.ID}: Internal ID for the taxon given by Gemma
\item \code{taxon.NCBI}: NCBI ID for the taxon
\item \code{taxon.database.name}: Name of the database used in Gemma for the taxon
}
}
\description{
Retrieve the physical locations of a given gene
}
\examples{
get_gene_locations("DYRK1A")
get_gene_locations(1859)
}
\keyword{gene}
