% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaksCAT.r
\name{peaksCAT}
\alias{peaksCAT}
\title{CATplot of Peaks}
\usage{
peaksCAT(x, y, ranks = seq(200, min(length(x), length(y), 20000), 50),
  exclude = GRanges(), seqinfo = NULL, esx = 1, esy = 1, add = FALSE,
  ...)
}
\arguments{
\item{x}{A GRanges of identified peaks from one method or one replicate.
At least one meta column should be included to allow for significance
ranking of peaks.}

\item{y}{A GRanges of identified peaks from compared method or
anoter replicate. At least one meta column should be included to
allow for significance ranking of peaks.}

\item{ranks}{A non-negative integer vector specifying the ranks to
be used for CAT plot.}

\item{exclude}{A GRanges object specifying regions to be excluded for
CAT plot, such as the blacklist regions proposed by ENCODE Consortium.}

\item{seqinfo}{A vector of chromosome names to limit the CAT plot to
selected chromosomes. Chromosome names here must be in the same format
as \code{seqnames} in \code{x} and \code{y}. This parameter also helps
exclude uncommon chromosomes, e.g. using value
\code{paste0('chr',c(1:22,'X','Y'))} for human genome. Default: NULL
means no limit to chromosomes.}

\item{esx}{A non-negative integer specifying which meta column of
\code{x} to be used to rank peak significance. Larger values in this
column should indicate higher significance.}

\item{esy}{A non-negative integer specifying which meta column of
\code{y} to be used to rank peak significance. Larger values in this
column should indicate higher significance.}

\item{add}{A logical vector which, when TRUE, adds the current plotting
line to existing plots. FALSE will generate a new plot.}

\item{...}{Other parameters passed to \code{plot} or \code{lines}.}
}
\value{
A CAT plot.
}
\description{
Plot the consistancy between two peak lists by their significance.
}
\examples{
bam <- system.file("extdata", "chipseq.bam", package="gcapc")
cov <- read5endCoverage(bam)
bdw <- bindWidth(cov)
gcb1 <- gcEffects(cov, bdw, sampling=c(0.15,1), plot=FALSE)
peaks1 <- gcapcPeaks(cov, gcb1, bdw)
gcb2 <- gcEffects(cov, bdw, sampling=c(0.2,1), plot=FALSE)
peaks2 <- gcapcPeaks(cov, gcb2, bdw)
peaksCAT(peaks1, peaks2, ranks=seq(100,200,5), ylim=c(0,1))
}
