% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/de.R
\name{getGeneDEMeta}
\alias{getGeneDEMeta}
\title{Finds columns in gene differential expression table
required for gatom analysis}
\usage{
getGeneDEMeta(
  gene.de.raw,
  org.gatom.anno,
  idColumn = NULL,
  idType = NULL,
  pvalColumn = NULL,
  logPvalColumn = NULL,
  log2FCColumn = NULL,
  baseMeanColumn = NULL,
  signalColumn = NULL,
  signalRankColumn = NULL
)
}
\arguments{
\item{gene.de.raw}{A table with differential expression results, an object
convertable to data.frame.}

\item{org.gatom.anno}{Organsim-specific annotation obtained from
makeOrgGatomAnnotation function.}

\item{idColumn}{Specifies column name with gene identifiers.}

\item{idType}{Specifies type of gene IDs (one of the supported by annotation).}

\item{pvalColumn}{Specifies column with p-values.}

\item{logPvalColumn}{Specifies column with log p-values, if there is no such
column one will be generated automatically.}

\item{log2FCColumn}{Specifies column with log2-fold changes.}

\item{baseMeanColumn}{Specifies column with average expression across samples.}

\item{signalColumn}{Specifies column with identifier of the measured entity
(such as gene ID for RNA-seq and probe ID for microarrays).
Could be NULL (automatic, set from based on pval and log2FC columns),
character (column name), or function (evaluated in a scope of original data frame)}

\item{signalRankColumn}{Specifies how the genes are ranked from highly to lowly expressed,
used in `addHighlyExpressedEdgues` function.
Could be NULL (automatic), character (column name)
function (evaluated in a scope of original data frame).}
}
\value{
object with prepared columns for the analysis for gene data
}
\description{
Default values for all columns are NULL which mean they are
determined automatically.
}
\examples{
data("org.Mm.eg.gatom.annoEx")
data("gene.de.rawEx")
de.meta <- getGeneDEMeta(gene.de.rawEx, org.gatom.anno = org.Mm.eg.gatom.annoEx)

}
