% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportOverlaps.R
\name{exportOverlapsToBed}
\alias{exportOverlapsToBed}
\title{Export Overlap Groups to BED Files}
\usage{
exportOverlapsToBed(
  grouped,
  output_dir = ".",
  output_prefix = "overlaps",
  with_date = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{grouped}{Genomic overlap groups from \code{extractOverlaps()}
(must be \code{GRangesList}).}

\item{output_dir}{A string specifying the output directory. Defaults to \code{"."}.}

\item{output_prefix}{A string specifying the filename prefix.
Defaults to \code{"overlaps"}.}

\item{with_date}{Logical (default \code{TRUE}). Whether to prepend the current
date to filenames.}

\item{verbose}{Logical. If \code{TRUE}, print messages. Default \code{TRUE}.}
}
\value{
Invisibly returns a character vector of file paths created.
}
\description{
This function exports genomic overlap groups from \code{extractOverlaps()} to
BED format files, creating one BED file per overlap group.
}
\details{
This function only works with genomic overlaps (i.e., when the input to
\code{extractOverlaps()} was a \code{GenomicOverlapResult} object, resulting in a
\code{GRangesList}). It does not work with set overlaps (character vectors).
Each overlap group will be saved as a separate BED file with the group
identifier included in the filename.
}
