% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeOverlaps.R
\name{computeOverlaps}
\alias{computeOverlaps}
\title{Compute Overlaps Between Multiple Sets or Genomic Regions}
\usage{
computeOverlaps(x)
}
\arguments{
\item{x}{Input sets. One of:
\itemize{
\item A \code{GRangesList} object.
\item A named list of \code{GRanges} objects.
\item A named list of atomic vectors (character, numeric, factor, etc.),
all of the same type.
}}
}
\value{
An S3 object encoding the overlap result whose class depends on the input
type:

\describe{
\item{GenomicOverlapResult}{Returned when the input is genomic
(\code{GRangesList} or list of \code{GRanges}). A list with:
\itemize{
\item \code{reduced_regions}: A \code{GRanges} object containing the
merged (non-redundant) intervals. Each region is annotated with
an \code{intersect_category} column.
\item \code{overlap_matrix}: A logical matrix indicating whether each
reduced region overlaps each input set (rows = regions,
columns = sets).
}}
\item{SetOverlapResult}{Returned when the input is a list of atomic
vectors. A list with:
\itemize{
\item \code{unique_elements}: Character vector of all unique elements
across the sets.
\item \code{overlap_matrix}: A logical matrix indicating whether each
element is present in each set (rows = elements, columns = sets).
\item \code{intersect_category}: Character vector of category codes
(e.g., \code{"110"}) for each element.
}}
}
}
\description{
\code{computeOverlaps()} is the main entry point for overlap analysis. It accepts
either genomic region objects (\code{GRanges}/\code{GRangesList}) or ordinary sets
(character/numeric vectors) and computes a binary overlap matrix describing
the presence or absence of each element across sets.
}
\details{
\itemize{
\item When provided with genomic regions, the function merges all intervals into
a non-redundant set (\code{reduce()}), then determines which original sets each
region overlaps.
\item When provided with ordinary sets (e.g., gene symbols), it collects all
unique elements and records which sets contain them.
}

The resulting object encodes both the overlap matrix and compact category
labels (e.g., \code{"110"}) representing the overlap pattern of each element.
These results can be directly passed to visualization functions such as
\code{plotVenn()} or \code{plotUpSet()}.

Internally, \code{computeOverlaps()} dispatches to either
\code{computeGenomicOverlaps()} (for genomic inputs) or
\code{computeSetOverlaps()} (for ordinary sets). Users are encouraged to call
only \code{computeOverlaps()}.
}
\examples{
# Example with gene sets (built-in dataset)
data(gene_list)
ov_sets <- computeOverlaps(gene_list)
head(ov_sets$overlap_matrix)
plotVenn(ov_sets)

# Example with genomic regions (built-in dataset)
data(a549_chipseq_peaks)
ov_gr <- computeOverlaps(a549_chipseq_peaks)
head(ov_gr$overlap_matrix)
plotVenn(ov_gr)

}
\seealso{
\code{\link{plotVenn}}, \code{\link{plotUpSet}},
\code{\link[GenomicRanges]{GRangesList}}, \code{\link[GenomicRanges]{reduce}}
}
