% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_mae_se_assay_to_dt.R
\name{update_drug_name}
\alias{update_drug_name}
\title{Update drug name with additional variables}
\usage{
update_drug_name(dt, additional_vars)
}
\arguments{
\item{dt}{A data.table containing drug-response information, including drug
identifier columns (e.g., \code{DrugName}, \code{Gnumber}) and the \code{additional_vars}.}

\item{additional_vars}{Character vector of column names (variables) to merge
into the drug identifier columns.}
}
\value{
A copy of the input data.table \code{dt} with the relevant drug
identifier columns updated to include the additional variable information in the format:
\code{Identifier (variable = value)}.
}
\description{
Concatenates the values of specified additional variables to the existing
drug identifier columns in a data.table, using the variables defined in
\code{get_env_identifiers}.
}
\examples{
# Assuming get_env_identifiers() returns c("DrugName", "Gnumber") for drug identifiers
dt <- data.table::data.table(
  DrugName = c("DrugA", "DrugA", "DrugB"),
  Gnumber = c("G1", "G1", "G2"),
  Var1 = c(NA, "X", NA),
  Var2 = c(NA, "Y", "Z")
)
additional_vars <- c("Var1", "Var2")
 dt_updated <- update_drug_name(dt, additional_vars)
# Would update DrugName and Gnumber
dt_updated

}
\keyword{internal}
