% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{split_big_table_for_xlsx}
\alias{split_big_table_for_xlsx}
\title{Split big table}
\usage{
split_big_table_for_xlsx(dt_list, max_row = 1e+06, max_col = 16000)
}
\arguments{
\item{dt_list}{list of data.tables. Each data.table will be checked and
split if meet the criteria}

\item{max_row}{integer defining the maximum number of rows in one sheet, the
rows will be divided into portions of this size. Default value, 1 000 000,
is based on excel limit - 1 048 576 with extra safety margin}

\item{max_col}{integer defining the maximum number of columns in one sheet,
the columns will be divided into portions of this size. Default value,
16 000, is based on excel limit - 16 384 with extra safety margin}
}
\value{
list of data.tables
}
\description{
Helper function for saving big tables in an Excel file. Excel has a
sheet size limit, if the table is too large it will not be possible to save
such a file. This function allows you to split the table into smaller parts
so that saving can be possible
}
\examples{
too_large_dt <- list(data.table::data.table(matrix(seq_len(300)), nrow = 10))
split_big_table_for_xlsx(too_large_dt, max_row = 250)

}
\keyword{package_utils}
