% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_input.R
\name{prepare_input.MultiAssayExperiment}
\alias{prepare_input.MultiAssayExperiment}
\title{Prepare input data common for all experiments}
\usage{
\method{prepare_input}{MultiAssayExperiment}(
  x,
  nested_confounders = gDRutils::get_SE_identifiers(x[[1]], "barcode"),
  nested_identifiers_l = .get_default_nested_identifiers(x[[1]]),
  raw_data_field = "experiment_raw_data",
  split_data = TRUE,
  ...
)
}
\arguments{
\item{x}{MAE object with dose-response data}

\item{nested_confounders}{Character vector of the nested_confounders for
a given assay. nested_keys is character vector of column names to include
in the data.tables in the assays of the resulting
\code{SummarizedExperiment} object. Defaults to the \code{nested_identifiers}
and \code{nested_confounders} if passed through}

\item{nested_identifiers_l}{list with the
nested_identifiers(character vectors) for \code{single-agent} and (optionally)
for \code{combination} data}

\item{raw_data_field}{metadata field with raw data}

\item{split_data}{Boolean indicating need of splitting the data into
experiment types}

\item{...}{additional parameters}
}
\value{
list of input data
}
\description{
Current steps
\itemize{
\item refining nested confounders
\item refining nested identifiers
\item splitting df_ into (per experiment) df_list
}
}
\keyword{prepare_input}
