% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenePvalsFromEset.R
\name{ct.applyAlpha}
\alias{ct.applyAlpha}
\title{Apply RRA 'alpha' cutoff to RRAalpha input}
\usage{
ct.applyAlpha(
  stats,
  RRAalphaCutoff = 0.1,
  scoring = c("combined", "pvalue", "fc")
)
}
\arguments{
\item{stats}{three-column numeric matrix with pvalues for down and up one-sided test with guide-level fold
changes (coefficients from the relevant contrast).}

\item{RRAalphaCutoff}{A cutoff to use when defining gRNAs with significantly altered abundance during the RRAa aggregation step, which may be specified
as a single numeric value on the unit interval or as a logical vector. When supplied as a logical vector (of length equal to \code{nrows(fit)}), 
this parameter directly indicates the gRNAs to include during RRAa aggregation. Otherwise, if \code{scoring} is set 
to \code{pvalue} or \code{combined}, this parameter is interpreted as the maximum nominal p-value required to consider a gRNA's abundance meaningfully 
altered during the aggregation step. If \code{scoring} is \code{fc}, this parameter is interpreted as the proportion of the list to be considered 
meaningfully altered in the experiment (e.g., if \code{RRAalphaCutoff} is set to 0.05, only consider the rankings of the 5% most upregulated 
(or downregulated) gRNAs for the purposes of RRAa calculations).}

\item{scoring}{The gRNA ranking method to use in RRAa aggregation. May take one of three values: \code{pvalue}, \code{fc},
or '\code{combined}'. \code{pvalue} indicates that the gRNA ranking statistic should be created from the (one-sided) p-values in the 
fit object. \code{fc} indicates that the ranks of the gRNA coefficients should be used instead, and \code{combined} indicates that 
that the coefficents should be used as the ranking statistic but gRNAs are discarded in the aggregation step based on the corresponding nominal 
p-value in the fit object.}
}
\value{
data.frame with guide-level pvals, fold change, and scores.deplete and scores.enrich which are the input the RRAalpha
}
\description{
The 'alpha' part of RRAalpha is used to consider only the top guide-level scores for gene-level
    statistics. Practically, all guides failing the cutoff get a pvalue of 1.  There are three ways of
    determining which guides fail. See 'scoring' below.
}
\examples{
fakestats <- matrix(runif(300), ncol = 3)
colnames(fakestats) = c('Depletion.P', 'Enrichment.P', 'lfc')
ct.applyAlpha(fakestats)
}
\author{
Russell Bainer
}
